/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.RemotePluginClientFactory;
import org.eclipse.keyple.distributed.RemotePluginClientFactoryAdapter;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClientSpi;
import org.eclipse.keyple.distributed.spi.SyncEndpointClientSpi;

public final class RemotePoolPluginClientFactoryBuilder {
    private RemotePoolPluginClientFactoryBuilder() {
    }

    public static NodeStep builder(String remotePluginName) {
        return new Builder(remotePluginName);
    }

    private static final class Builder
    implements NodeStep,
    BuilderStep {
        private final String remotePluginName;
        private SyncEndpointClientSpi syncEndpoint;
        private AsyncEndpointClientSpi asyncEndpoint;
        private int asyncNodeClientTimeoutSeconds;

        private Builder(String remotePluginName) {
            Assert.getInstance().notEmpty(remotePluginName, "remotePluginName");
            this.remotePluginName = remotePluginName;
        }

        @Override
        public BuilderStep withSyncNode(SyncEndpointClientSpi endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.syncEndpoint = endpoint;
            return this;
        }

        @Override
        public BuilderStep withAsyncNode(AsyncEndpointClientSpi endpoint, int timeoutSeconds) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint").greaterOrEqual(Integer.valueOf(timeoutSeconds), 1, "timeoutSeconds");
            this.asyncEndpoint = endpoint;
            this.asyncNodeClientTimeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public RemotePluginClientFactory build() {
            return new RemotePluginClientFactoryAdapter(this.remotePluginName, true, false, false, this.syncEndpoint, null, null, this.asyncEndpoint, this.asyncNodeClientTimeoutSeconds);
        }
    }

    public static interface BuilderStep {
        public RemotePluginClientFactory build();
    }

    public static interface NodeStep {
        public BuilderStep withSyncNode(SyncEndpointClientSpi var1);

        public BuilderStep withAsyncNode(AsyncEndpointClientSpi var1, int var2);
    }
}

