/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.RemotePluginServerFactory;
import org.eclipse.keyple.distributed.RemotePluginServerFactoryAdapter;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServerSpi;

public final class RemotePluginServerFactoryBuilder {
    private RemotePluginServerFactoryBuilder() {
    }

    public static NodeStep builder(String remotePluginName) {
        return new Builder(remotePluginName);
    }

    public static NodeStep builder(String remotePluginName, ExecutorService executorService) {
        return new Builder(remotePluginName, executorService);
    }

    private static final class Builder
    implements NodeStep,
    BuilderStep {
        private final String remotePluginName;
        private final ExecutorService executorService;
        private AsyncEndpointServerSpi asyncEndpoint;

        public Builder(String remotePluginName) {
            Assert.getInstance().notEmpty(remotePluginName, "remotePluginName");
            this.remotePluginName = remotePluginName;
            this.executorService = null;
        }

        private Builder(String remotePluginName, ExecutorService executorService) {
            Assert.getInstance().notEmpty(remotePluginName, "remotePluginName").notNull((Object)executorService, "executorService");
            this.remotePluginName = remotePluginName;
            this.executorService = executorService;
        }

        @Override
        public BuilderStep withSyncNode() {
            return this;
        }

        @Override
        public BuilderStep withAsyncNode(AsyncEndpointServerSpi endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.asyncEndpoint = endpoint;
            return this;
        }

        @Override
        public RemotePluginServerFactory build() {
            return new RemotePluginServerFactoryAdapter(this.remotePluginName, this.executorService, this.asyncEndpoint);
        }
    }

    public static interface BuilderStep {
        public RemotePluginServerFactory build();
    }

    public static interface NodeStep {
        public BuilderStep withSyncNode();

        public BuilderStep withAsyncNode(AsyncEndpointServerSpi var1);
    }
}

