/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.distributed.remote.spi.AbstractRemotePluginSpi;
import org.eclipse.keyple.distributed.AbstractRemotePluginFactoryAdapter;
import org.eclipse.keyple.distributed.ObservableRemotePluginServerAdapter;
import org.eclipse.keyple.distributed.RemotePluginServerFactory;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServerSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemotePluginServerFactoryAdapter
extends AbstractRemotePluginFactoryAdapter
implements RemotePluginServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(RemotePluginServerFactoryAdapter.class);
    private final ExecutorService executorService;
    private final AsyncEndpointServerSpi asyncEndpointServerSpi;

    RemotePluginServerFactoryAdapter(String remotePluginName, ExecutorService executorService, AsyncEndpointServerSpi asyncEndpointServerSpi) {
        super(remotePluginName);
        this.executorService = executorService;
        this.asyncEndpointServerSpi = asyncEndpointServerSpi;
    }

    public AbstractRemotePluginSpi getRemotePlugin() {
        ObservableRemotePluginServerAdapter remotePlugin = new ObservableRemotePluginServerAdapter(this.getRemotePluginName(), this.executorService);
        String nodeType = this.asyncEndpointServerSpi != null ? "AsyncNodeServer" : "SyncNodeServer";
        logger.info("Create a new 'RemotePluginServer' with name='{}', nodeType='{}'.", (Object)this.getRemotePluginName(), (Object)nodeType);
        if (this.asyncEndpointServerSpi == null) {
            remotePlugin.bindSyncNodeServer();
        } else {
            remotePlugin.bindAsyncNodeServer(this.asyncEndpointServerSpi);
        }
        return remotePlugin;
    }
}

