/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.RemotePluginClientFactory;
import org.eclipse.keyple.distributed.RemotePluginClientFactoryAdapter;
import org.eclipse.keyple.distributed.ServerPushEventStrategyAdapter;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClientSpi;
import org.eclipse.keyple.distributed.spi.SyncEndpointClientSpi;

public final class RemotePluginClientFactoryBuilder {
    private RemotePluginClientFactoryBuilder() {
    }

    public static NodeStep builder(String remotePluginName) {
        return new Builder(remotePluginName);
    }

    private static final class Builder
    implements NodeStep,
    SyncNodePluginStep,
    ServerPushPluginEventStrategyStep,
    SyncNodeReaderStep,
    ServerPushReaderEventStrategyStep,
    BuilderStep {
        private final String remotePluginName;
        private boolean isPluginObservationEnabled;
        private boolean isReaderObservationEnabled;
        private SyncEndpointClientSpi syncEndpoint;
        private ServerPushEventStrategyAdapter syncPluginObservationStrategy;
        private ServerPushEventStrategyAdapter syncReaderObservationStrategy;
        private AsyncEndpointClientSpi asyncEndpoint;
        private int asyncNodeClientTimeoutSeconds;

        private Builder(String remotePluginName) {
            Assert.getInstance().notEmpty(remotePluginName, "remotePluginName");
            this.remotePluginName = remotePluginName;
            this.isPluginObservationEnabled = true;
            this.isReaderObservationEnabled = true;
        }

        @Override
        public SyncNodePluginStep withSyncNode(SyncEndpointClientSpi endpoint) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint");
            this.syncEndpoint = endpoint;
            return this;
        }

        @Override
        public BuilderStep withAsyncNode(AsyncEndpointClientSpi endpoint, int timeoutSeconds) {
            Assert.getInstance().notNull((Object)endpoint, "endpoint").greaterOrEqual(Integer.valueOf(timeoutSeconds), 1, "timeoutSeconds");
            this.asyncEndpoint = endpoint;
            this.asyncNodeClientTimeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public ServerPushPluginEventStrategyStep withPluginObservation() {
            return this;
        }

        @Override
        public SyncNodeReaderStep withoutPluginObservation() {
            this.isPluginObservationEnabled = false;
            return this;
        }

        @Override
        public SyncNodeReaderStep withPluginPollingStrategy(int requestFrequencyMillis) {
            Assert.getInstance().greaterOrEqual(Integer.valueOf(requestFrequencyMillis), 1, "requestFrequencyMillis");
            this.syncPluginObservationStrategy = new ServerPushEventStrategyAdapter(ServerPushEventStrategyAdapter.Type.POLLING, requestFrequencyMillis);
            return this;
        }

        @Override
        public SyncNodeReaderStep withPluginLongPollingStrategy(int requestTimeoutMillis) {
            Assert.getInstance().greaterOrEqual(Integer.valueOf(requestTimeoutMillis), 1, "requestTimeoutMillis");
            this.syncPluginObservationStrategy = new ServerPushEventStrategyAdapter(ServerPushEventStrategyAdapter.Type.LONG_POLLING, requestTimeoutMillis);
            return this;
        }

        @Override
        public ServerPushReaderEventStrategyStep withReaderObservation() {
            return this;
        }

        @Override
        public BuilderStep withoutReaderObservation() {
            this.isReaderObservationEnabled = false;
            return this;
        }

        @Override
        public BuilderStep withReaderPollingStrategy(int requestFrequencyMillis) {
            Assert.getInstance().greaterOrEqual(Integer.valueOf(requestFrequencyMillis), 1, "requestFrequencyMillis");
            this.syncReaderObservationStrategy = new ServerPushEventStrategyAdapter(ServerPushEventStrategyAdapter.Type.POLLING, requestFrequencyMillis);
            return this;
        }

        @Override
        public BuilderStep withReaderLongPollingStrategy(int requestTimeoutMillis) {
            Assert.getInstance().greaterOrEqual(Integer.valueOf(requestTimeoutMillis), 1, "requestTimeoutMillis");
            this.syncReaderObservationStrategy = new ServerPushEventStrategyAdapter(ServerPushEventStrategyAdapter.Type.LONG_POLLING, requestTimeoutMillis);
            return this;
        }

        @Override
        public RemotePluginClientFactory build() {
            return new RemotePluginClientFactoryAdapter(this.remotePluginName, false, this.isPluginObservationEnabled, this.isReaderObservationEnabled, this.syncEndpoint, this.syncPluginObservationStrategy, this.syncReaderObservationStrategy, this.asyncEndpoint, this.asyncNodeClientTimeoutSeconds);
        }
    }

    public static interface BuilderStep {
        public RemotePluginClientFactory build();
    }

    public static interface ServerPushReaderEventStrategyStep {
        public BuilderStep withReaderPollingStrategy(int var1);

        public BuilderStep withReaderLongPollingStrategy(int var1);
    }

    public static interface SyncNodeReaderStep {
        public ServerPushReaderEventStrategyStep withReaderObservation();

        public BuilderStep withoutReaderObservation();
    }

    public static interface ServerPushPluginEventStrategyStep {
        public SyncNodeReaderStep withPluginPollingStrategy(int var1);

        public SyncNodeReaderStep withPluginLongPollingStrategy(int var1);
    }

    public static interface SyncNodePluginStep {
        public ServerPushPluginEventStrategyStep withPluginObservation();

        public SyncNodeReaderStep withoutPluginObservation();
    }

    public static interface NodeStep {
        public SyncNodePluginStep withSyncNode(SyncEndpointClientSpi var1);

        public BuilderStep withAsyncNode(AsyncEndpointClientSpi var1, int var2);
    }
}

