/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.distributed.remote.spi.AbstractRemotePluginSpi;
import org.eclipse.keyple.distributed.AbstractRemotePluginClientAdapter;
import org.eclipse.keyple.distributed.AbstractRemotePluginFactoryAdapter;
import org.eclipse.keyple.distributed.ObservableRemotePluginClientAdapter;
import org.eclipse.keyple.distributed.RemotePluginClientAdapter;
import org.eclipse.keyple.distributed.RemotePluginClientFactory;
import org.eclipse.keyple.distributed.RemotePoolPluginClientAdapter;
import org.eclipse.keyple.distributed.ServerPushEventStrategyAdapter;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClientSpi;
import org.eclipse.keyple.distributed.spi.SyncEndpointClientSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemotePluginClientFactoryAdapter
extends AbstractRemotePluginFactoryAdapter
implements RemotePluginClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(RemotePluginClientFactoryAdapter.class);
    private final boolean isPoolPlugin;
    private final boolean isPluginObservationEnabled;
    private final boolean isReaderObservationEnabled;
    private final SyncEndpointClientSpi syncEndpointClientSpi;
    private final ServerPushEventStrategyAdapter syncPluginObservationStrategy;
    private final ServerPushEventStrategyAdapter syncReaderObservationStrategy;
    private final AsyncEndpointClientSpi asyncEndpointClientSpi;
    private final int asyncNodeClientTimeoutSeconds;

    RemotePluginClientFactoryAdapter(String remotePluginName, boolean isPoolPlugin, boolean isPluginObservationEnabled, boolean isReaderObservationEnabled, SyncEndpointClientSpi syncEndpointClientSpi, ServerPushEventStrategyAdapter syncPluginObservationStrategy, ServerPushEventStrategyAdapter syncReaderObservationStrategy, AsyncEndpointClientSpi asyncEndpointClientSpi, int asyncNodeClientTimeoutSeconds) {
        super(remotePluginName);
        this.isPoolPlugin = isPoolPlugin;
        this.isPluginObservationEnabled = isPluginObservationEnabled;
        this.isReaderObservationEnabled = isReaderObservationEnabled;
        this.syncEndpointClientSpi = syncEndpointClientSpi;
        this.syncPluginObservationStrategy = syncPluginObservationStrategy;
        this.syncReaderObservationStrategy = syncReaderObservationStrategy;
        this.asyncEndpointClientSpi = asyncEndpointClientSpi;
        this.asyncNodeClientTimeoutSeconds = asyncNodeClientTimeoutSeconds;
    }

    public AbstractRemotePluginSpi getRemotePlugin() {
        AbstractRemotePluginClientAdapter remotePlugin = this.isPoolPlugin ? new RemotePoolPluginClientAdapter(this.getRemotePluginName()) : (this.isPluginObservationEnabled ? new ObservableRemotePluginClientAdapter(this.getRemotePluginName(), this.isReaderObservationEnabled) : new RemotePluginClientAdapter(this.getRemotePluginName(), this.isReaderObservationEnabled));
        if (this.syncEndpointClientSpi != null) {
            String pluginObservationStrategy = this.syncPluginObservationStrategy != null ? this.syncPluginObservationStrategy.getType().name() + "_" + this.syncPluginObservationStrategy.getDurationMillis() + "_millis" : null;
            String readerObservationStrategy = this.syncReaderObservationStrategy != null ? this.syncReaderObservationStrategy.getType().name() + "_" + this.syncReaderObservationStrategy.getDurationMillis() + "_millis" : null;
            logger.info("Create a new 'RemotePluginClient' with name='{}', nodeType='SyncNodeClient', isPluginObservationEnabled={}, syncPluginObservationStrategy={}, isReaderObservationEnabled={}, syncReaderObservationStrategy={}.", new Object[]{this.getRemotePluginName(), this.isPluginObservationEnabled, pluginObservationStrategy, this.isReaderObservationEnabled, readerObservationStrategy});
            remotePlugin.bindSyncNodeClient(this.syncEndpointClientSpi, this.syncPluginObservationStrategy, this.syncReaderObservationStrategy);
        } else {
            logger.info("Create a new 'RemotePluginClient' with name='{}', nodeType='AsyncNodeClient', timeoutSeconds={}, isPluginObservationEnabled={}, isReaderObservationEnabled={}.", new Object[]{this.getRemotePluginName(), this.asyncNodeClientTimeoutSeconds, this.isPluginObservationEnabled, this.isReaderObservationEnabled});
            remotePlugin.bindAsyncNodeClient(this.asyncEndpointClientSpi, this.asyncNodeClientTimeoutSeconds);
        }
        return remotePlugin;
    }
}

