/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.distributed.remote.RemotePluginApi;
import org.eclipse.keyple.core.distributed.remote.spi.ObservableRemoteReaderSpi;
import org.eclipse.keyple.core.distributed.remote.spi.RemotePluginSpi;
import org.eclipse.keyple.core.distributed.remote.spi.RemoteReaderSpi;
import org.eclipse.keyple.distributed.AbstractRemotePluginClientAdapter;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.ObservableRemoteReaderClientAdapter;
import org.eclipse.keyple.distributed.RemoteReaderClientAdapter;

class RemotePluginClientAdapter
extends AbstractRemotePluginClientAdapter
implements RemotePluginSpi {
    private final boolean isReaderObservationEnabled;
    private RemotePluginApi remotePluginApi;

    RemotePluginClientAdapter(String remotePluginName, boolean isReaderObservationEnabled) {
        super(remotePluginName);
        this.isReaderObservationEnabled = isReaderObservationEnabled;
    }

    public void connect(RemotePluginApi remotePluginApi) {
        this.remotePluginApi = remotePluginApi;
    }

    public final RemoteReaderSpi createRemoteReader(String remoteReaderName, String localReaderName) {
        return new RemoteReaderClientAdapter(this.getCoreApiLevel(), remoteReaderName, localReaderName, this.getGlobalSessionId(), this.getNode().getNodeId(), this.getNode());
    }

    public final ObservableRemoteReaderSpi createObservableRemoteReader(String remoteReaderName, String localReaderName) {
        if (!this.isReaderObservationEnabled) {
            throw new IllegalStateException("Cannot create the observable remote reader because the reader observation strategy is not configured.");
        }
        return new ObservableRemoteReaderClientAdapter(this.getCoreApiLevel(), remoteReaderName, localReaderName, this.getGlobalSessionId(), this.getNode().getNodeId(), this.getNode());
    }

    void onMessage(MessageDto message) {
        if (MessageDto.Action.READER_EVENT.name().equals(message.getAction())) {
            this.remotePluginApi.onReaderEvent(message.getBody());
        }
    }
}

