/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.keyple.core.distributed.remote.ObservableRemotePluginApi;
import org.eclipse.keyple.core.distributed.remote.RemotePluginApi;
import org.eclipse.keyple.core.distributed.remote.spi.ObservableRemotePluginSpi;
import org.eclipse.keyple.core.distributed.remote.spi.ObservableRemoteReaderSpi;
import org.eclipse.keyple.core.distributed.remote.spi.RemoteReaderSpi;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.JsonUtil;
import org.eclipse.keyple.distributed.AbstractRemotePluginAdapter;
import org.eclipse.keyple.distributed.AsyncNodeServer;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.RemotePluginServer;
import org.eclipse.keyple.distributed.RemoteReaderServerAdapter;
import org.eclipse.keyple.distributed.SyncNodeServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObservableRemotePluginServerAdapter
extends AbstractRemotePluginAdapter
implements RemotePluginServer,
ObservableRemotePluginSpi {
    private static final Logger logger = LoggerFactory.getLogger(ObservableRemotePluginServerAdapter.class);
    private final ExecutorService executorService;
    private final Map<String, RemoteReaderServerAdapter> readers;
    private ObservableRemotePluginApi observableRemotePluginApi;

    ObservableRemotePluginServerAdapter(String remotePluginName, ExecutorService executorService) {
        super(remotePluginName);
        this.executorService = executorService;
        this.readers = new ConcurrentHashMap<String, RemoteReaderServerAdapter>();
    }

    @Override
    public SyncNodeServer getSyncNode() {
        if (this.isBoundToSyncNode()) {
            return (SyncNodeServer)this.getNode();
        }
        throw new IllegalStateException(String.format("Remote plugin '%s' is not configured with a synchronous network protocol.", this.getName()));
    }

    @Override
    public AsyncNodeServer getAsyncNode() {
        if (!this.isBoundToSyncNode()) {
            return (AsyncNodeServer)this.getNode();
        }
        throw new IllegalStateException(String.format("Remote plugin '%s' is not configured with an asynchronous network protocol.", this.getName()));
    }

    @Override
    public void endRemoteService(String remoteReaderName, Object outputData) {
        Assert.getInstance().notEmpty(remoteReaderName, "remoteReaderName");
        RemoteReaderServerAdapter reader = this.readers.remove(remoteReaderName);
        if (reader == null) {
            throw new IllegalArgumentException(String.format("No reader exists with name '%s'", remoteReaderName));
        }
        this.observableRemotePluginApi.removeRemoteReader(remoteReaderName);
        JsonObject body = new JsonObject();
        if (reader.getClientCoreApiLevel() != 0) {
            body.addProperty(MessageDto.JsonProperty.CORE_API_LEVEL.getKey(), (Number)reader.getClientCoreApiLevel());
        }
        if (reader.getClientDistributedApiLevel() != 0) {
            body.add(MessageDto.JsonProperty.OUTPUT_DATA.getKey(), JsonUtil.getParser().toJsonTree(outputData));
        } else {
            body.addProperty(MessageDto.JsonProperty.OUTPUT_DATA.name(), JsonUtil.toJson((Object)outputData));
        }
        MessageDto message = new MessageDto().setApiLevel(reader.getClientDistributedApiLevel()).setAction(MessageDto.Action.END_REMOTE_SERVICE.name()).setRemoteReaderName(remoteReaderName).setSessionId(reader.getSessionId()).setClientNodeId(reader.getClientNodeId()).setBody(body.toString());
        this.getNode().sendMessage(message);
    }

    public String executeRemotely(String jsonData) {
        return null;
    }

    public void onUnregister() {
    }

    public void connect(RemotePluginApi remotePluginApi) {
    }

    public RemoteReaderSpi createRemoteReader(String remoteReaderName, String localReaderName) {
        throw new UnsupportedOperationException("createRemoteReader");
    }

    public ObservableRemoteReaderSpi createObservableRemoteReader(String remoteReaderName, String localReaderName) {
        throw new UnsupportedOperationException("createObservableRemoteReader");
    }

    public void connect(ObservableRemotePluginApi observableRemotePluginApi) {
        this.observableRemotePluginApi = observableRemotePluginApi;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void onStartObservation() {
    }

    public void onStopObservation() {
    }

    void onMessage(MessageDto message) {
        String serviceId;
        if (!MessageDto.Action.EXECUTE_REMOTE_SERVICE.name().equals(message.getAction())) {
            throw new IllegalStateException(String.format("Message not supported : %s", message));
        }
        JsonObject body = (JsonObject)JsonUtil.getParser().fromJson(message.getBody(), JsonObject.class);
        int clientDistributedApiLevel = message.getApiLevel() != 0 ? message.getApiLevel() : (body.has(MessageDto.JsonProperty.SERVICE_ID.getKey()) ? 1 : 0);
        int clientCoreApiLevel = body.has(MessageDto.JsonProperty.CORE_API_LEVEL.getKey()) ? body.get(MessageDto.JsonProperty.CORE_API_LEVEL.getKey()).getAsInt() : -1;
        String initialCardContent = null;
        String initialCardContentClassName = null;
        String inputData = null;
        if (clientDistributedApiLevel != 0) {
            serviceId = body.get(MessageDto.JsonProperty.SERVICE_ID.getKey()).getAsString();
            if (body.has(MessageDto.JsonProperty.INITIAL_CARD_CONTENT.getKey())) {
                initialCardContent = body.getAsJsonObject(MessageDto.JsonProperty.INITIAL_CARD_CONTENT.getKey()).toString();
                initialCardContentClassName = body.get(MessageDto.JsonProperty.INITIAL_CARD_CONTENT_CLASS_NAME.getKey()).getAsString();
            }
            if (body.has(MessageDto.JsonProperty.INPUT_DATA.getKey())) {
                inputData = body.getAsJsonObject(MessageDto.JsonProperty.INPUT_DATA.getKey()).toString();
            }
        } else {
            serviceId = body.get(MessageDto.JsonProperty.SERVICE_ID.name()).getAsString();
            if (body.has(MessageDto.JsonProperty.INITIAL_CARD_CONTENT.name())) {
                initialCardContent = body.get(MessageDto.JsonProperty.INITIAL_CARD_CONTENT.name()).getAsString();
                initialCardContentClassName = body.get(MessageDto.JsonProperty.INITIAL_CARD_CONTENT_CLASS_NAME.name()).getAsString();
            }
            if (body.has(MessageDto.JsonProperty.INPUT_DATA.name())) {
                inputData = body.get(MessageDto.JsonProperty.INPUT_DATA.name()).getAsString();
            }
        }
        String remoteReaderName = UUID.randomUUID().toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Remote plugin '{}' creates the remote reader '{}' with serviceId='{}', sessionId='{}', clientNodeId='{}'.", new Object[]{this.getName(), remoteReaderName, serviceId, message.getSessionId(), message.getClientNodeId()});
        }
        RemoteReaderServerAdapter remoteReader = new RemoteReaderServerAdapter(clientDistributedApiLevel, clientCoreApiLevel, remoteReaderName, message.getLocalReaderName(), message.getSessionId(), message.getClientNodeId(), this.getNode(), serviceId, initialCardContent, initialCardContentClassName, inputData);
        this.readers.put(remoteReader.getName(), remoteReader);
        this.observableRemotePluginApi.addRemoteReader((RemoteReaderSpi)remoteReader, clientCoreApiLevel);
    }
}

