/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.distributed.remote.spi.RemoteReaderSpi;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.MessageDto;

abstract class AbstractRemoteReaderAdapter
implements RemoteReaderSpi {
    private final int clientDistributedApiLevel;
    private final int clientCoreApiLevel;
    private final String remoteReaderName;
    private final String localReaderName;
    private final String sessionId;
    private final String clientNodeId;
    private final AbstractNodeAdapter node;

    AbstractRemoteReaderAdapter(int clientDistributedApiLevel, int clientCoreApiLevel, String remoteReaderName, String localReaderName, String sessionId, String clientNodeId, AbstractNodeAdapter node) {
        this.clientDistributedApiLevel = clientDistributedApiLevel;
        this.clientCoreApiLevel = clientCoreApiLevel;
        this.remoteReaderName = remoteReaderName;
        this.localReaderName = localReaderName;
        this.sessionId = sessionId;
        this.clientNodeId = clientNodeId;
        this.node = node;
    }

    final int getClientDistributedApiLevel() {
        return this.clientDistributedApiLevel;
    }

    final int getClientCoreApiLevel() {
        return this.clientCoreApiLevel;
    }

    final String getLocalReaderName() {
        return this.localReaderName;
    }

    final String getSessionId() {
        return this.sessionId;
    }

    final String getClientNodeId() {
        return this.clientNodeId;
    }

    final AbstractNodeAdapter getNode() {
        return this.node;
    }

    public final String getName() {
        return this.remoteReaderName;
    }

    public final String executeRemotely(String jsonData) {
        MessageDto message = new MessageDto().setApiLevel(this.clientDistributedApiLevel).setAction(MessageDto.Action.CMD.name()).setRemoteReaderName(this.remoteReaderName).setLocalReaderName(this.localReaderName).setClientNodeId(this.clientNodeId).setSessionId(this.sessionId != null ? this.sessionId : AbstractMessageHandlerAdapter.generateSessionId()).setBody(jsonData);
        MessageDto response = this.node.sendRequest(message);
        AbstractMessageHandlerAdapter.checkError((MessageDto)response);
        return response.getBody();
    }
}

