/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.distributed.AbstractRemotePluginAdapter;
import org.eclipse.keyple.distributed.AsyncNodeClient;
import org.eclipse.keyple.distributed.RemotePluginClient;

abstract class AbstractRemotePluginClientAdapter
extends AbstractRemotePluginAdapter
implements RemotePluginClient {
    private String globalSessionId;

    AbstractRemotePluginClientAdapter(String remotePluginName) {
        super(remotePluginName);
    }

    final String getGlobalSessionId() {
        return this.globalSessionId;
    }

    @Override
    public final AsyncNodeClient getAsyncNode() {
        if (!this.isBoundToSyncNode()) {
            return (AsyncNodeClient)this.getNode();
        }
        throw new IllegalStateException(String.format("Remote plugin '%s' is not configured with an asynchronous network protocol.", this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String executeRemotely(String jsonData) {
        if (this.isBoundToSyncNode()) {
            String sessionId = AbstractRemotePluginClientAdapter.generateSessionId();
            try {
                this.getNode().openSession(sessionId);
                String string = this.executeRemotely(jsonData, sessionId);
                return string;
            }
            finally {
                this.getNode().closeSessionSilently(sessionId);
            }
        }
        if (this.globalSessionId == null) {
            this.globalSessionId = AbstractRemotePluginClientAdapter.generateSessionId();
            this.getNode().openSession(this.globalSessionId);
        }
        return this.executeRemotely(jsonData, this.globalSessionId);
    }

    public final void onUnregister() {
        if (this.globalSessionId != null) {
            try {
                this.getNode().closeSessionSilently(this.globalSessionId);
            }
            finally {
                this.globalSessionId = null;
            }
        }
    }
}

