/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.ServerPushEventStrategyAdapter;
import org.eclipse.keyple.distributed.SyncNodeServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncNodeServerAdapter
extends AbstractNodeAdapter
implements SyncNodeServer {
    private static final Logger logger = LoggerFactory.getLogger(SyncNodeServerAdapter.class);
    private final Map<String, SessionManager> sessionManagers;
    private final Map<String, ServerPushEventManager> pluginManagers;
    private final Map<String, ServerPushEventManager> readerManagers;
    private final JsonParser jsonParser = new JsonParser();
    private long lastCleanDatetime;
    private final Object cleanMonitor;

    SyncNodeServerAdapter(AbstractMessageHandlerAdapter handler, int timeoutSeconds) {
        super(handler, timeoutSeconds);
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
        this.pluginManagers = new ConcurrentHashMap<String, ServerPushEventManager>();
        this.readerManagers = new ConcurrentHashMap<String, ServerPushEventManager>();
        this.cleanMonitor = new Object();
    }

    @Override
    public List<MessageDto> onRequest(MessageDto message) {
        List<MessageDto> responses;
        Assert.getInstance().notNull((Object)message, "message").notEmpty(message.getSessionId(), "sessionId").notEmpty(message.getAction(), "action").notEmpty(message.getClientNodeId(), "clientNodeId");
        MessageDto.Action action = MessageDto.Action.valueOf(message.getAction());
        switch (action) {
            case CHECK_PLUGIN_EVENT: {
                responses = this.checkEvents(message, this.pluginManagers);
                break;
            }
            case CHECK_READER_EVENT: {
                responses = this.checkEvents(message, this.readerManagers);
                break;
            }
            default: {
                responses = this.processOnRequest(message);
            }
        }
        return responses != null ? responses : Collections.emptyList();
    }

    private List<MessageDto> checkEvents(MessageDto message, Map<String, ServerPushEventManager> eventManagers) {
        ServerPushEventManager manager = this.getEventManager(message, eventManagers);
        return manager.checkEvents(message);
    }

    private List<MessageDto> processOnRequest(MessageDto message) {
        MessageDto response;
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        if (manager == null) {
            manager = new SessionManager(message.getSessionId());
            this.sessionManagers.put(message.getSessionId(), manager);
        }
        return (response = manager.onRequest(message)) != null ? Collections.singletonList(response) : null;
    }

    @Override
    MessageDto sendRequest(MessageDto message) {
        message.setServerNodeId(this.getNodeId());
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        try {
            return manager.sendRequest(message);
        }
        catch (RuntimeException e) {
            this.sessionManagers.remove(message.getSessionId());
            throw e;
        }
    }

    @Override
    void sendMessage(MessageDto message) {
        message.setServerNodeId(this.getNodeId());
        MessageDto.Action action = MessageDto.Action.valueOf(message.getAction());
        switch (action) {
            case PLUGIN_EVENT: {
                this.postEvent(message, this.pluginManagers);
                break;
            }
            case READER_EVENT: {
                this.postEvent(message, this.readerManagers);
                break;
            }
            default: {
                this.processSendMessage(message);
            }
        }
    }

    private void postEvent(MessageDto message, Map<String, ServerPushEventManager> eventManagers) {
        this.checkEventManagers(eventManagers, message.getClientNodeId());
        ServerPushEventManager manager = this.getEventManager(message, eventManagers);
        manager.postEvent(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEventManagers(Map<String, ServerPushEventManager> eventManagers, String clientNodeId) {
        HashSet<String> unusedClientNodeIds = new HashSet<String>();
        if (System.currentTimeMillis() > this.lastCleanDatetime + TimeUnit.DAYS.toMillis(1L)) {
            Object object = this.cleanMonitor;
            synchronized (object) {
                if (System.currentTimeMillis() > this.lastCleanDatetime + TimeUnit.DAYS.toMillis(1L)) {
                    long limitDatetime = this.lastCleanDatetime;
                    this.lastCleanDatetime = System.currentTimeMillis();
                    for (Map.Entry<String, ServerPushEventManager> entry : eventManagers.entrySet()) {
                        if (entry.getValue().lastCheckDatetime >= limitDatetime) continue;
                        unusedClientNodeIds.add(entry.getKey());
                    }
                    for (String key : unusedClientNodeIds) {
                        eventManagers.remove(key);
                    }
                }
            }
        }
        if (unusedClientNodeIds.contains(clientNodeId)) {
            throw new IllegalStateException(String.format("Client node ID '%s' removed because not used for at least 1 day", clientNodeId));
        }
    }

    private ServerPushEventManager getEventManager(MessageDto message, Map<String, ServerPushEventManager> eventManagers) {
        ServerPushEventManager manager = eventManagers.get(message.getClientNodeId());
        if (manager == null) {
            manager = new ServerPushEventManager(message.getClientNodeId());
            eventManagers.put(message.getClientNodeId(), manager);
        }
        return manager;
    }

    private void processSendMessage(MessageDto message) {
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        if (manager == null) {
            throw new IllegalStateException("Session is closed");
        }
        try {
            manager.sendMessage(message);
        }
        finally {
            this.sessionManagers.remove(message.getSessionId());
        }
    }

    private class ServerPushEventManager {
        private final String clientNodeId;
        private List<MessageDto> events;
        private ServerPushEventStrategyAdapter strategy;
        private long lastCheckDatetime;

        private ServerPushEventManager(String clientNodeId) {
            this.clientNodeId = clientNodeId;
            this.events = null;
            this.strategy = null;
            this.lastCheckDatetime = System.currentTimeMillis();
        }

        private synchronized void postEvent(MessageDto message) {
            if (this.events == null) {
                this.events = new ArrayList<MessageDto>(1);
            }
            this.events.add(message);
            if (this.strategy != null && this.strategy.getType() == ServerPushEventStrategyAdapter.Type.LONG_POLLING) {
                this.notifyAll();
            }
        }

        private synchronized List<MessageDto> checkEvents(MessageDto message) {
            try {
                this.lastCheckDatetime = System.currentTimeMillis();
                if (this.events != null) {
                    List<MessageDto> list = this.events;
                    return list;
                }
                this.registerClientStrategy(message);
                if (this.strategy.getType() == ServerPushEventStrategyAdapter.Type.LONG_POLLING) {
                    this.waitAtMost(this.strategy.getDurationMillis());
                }
                List<MessageDto> list = this.events;
                return list;
            }
            finally {
                this.events = null;
            }
        }

        private void registerClientStrategy(MessageDto message) {
            if (this.strategy == null) {
                ServerPushEventStrategyAdapter.Type type;
                JsonObject body;
                try {
                    body = SyncNodeServerAdapter.this.jsonParser.parse(message.getBody()).getAsJsonObject();
                    type = ServerPushEventStrategyAdapter.Type.valueOf(body.get(MessageDto.JsonProperty.STRATEGY.getKey()).getAsString());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("body", e);
                }
                int durationSeconds = 0;
                if (type == ServerPushEventStrategyAdapter.Type.LONG_POLLING) {
                    try {
                        durationSeconds = body.get(MessageDto.JsonProperty.DURATION.getKey()).getAsInt();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("long polling duration", e);
                    }
                }
                this.strategy = new ServerPushEventStrategyAdapter(type, durationSeconds);
            }
        }

        private synchronized void waitAtMost(int maxAwaitingTimeMillis) {
            try {
                long deadline = new Date().getTime() + (long)maxAwaitingTimeMillis;
                while (this.events == null && new Date().getTime() < deadline) {
                    this.wait(maxAwaitingTimeMillis);
                }
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption of the task associated with the node's id {}", (Object)this.clientNodeId, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private class SessionManager
    extends AbstractNodeAdapter.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
        }

        private synchronized MessageDto onRequest(MessageDto message) {
            this.checkState(AbstractNodeAdapter.SessionManagerState.INITIALIZED, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN);
            if (this.state == AbstractNodeAdapter.SessionManagerState.INITIALIZED) {
                this.state = AbstractNodeAdapter.SessionManagerState.ON_REQUEST;
                SyncNodeServerAdapter.this.getHandler().onMessage(message);
            } else {
                this.postMessageAndNotify(message, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END);
            }
            this.waitForState(AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN);
            return this.response;
        }

        private synchronized MessageDto sendRequest(MessageDto message) {
            this.postMessageAndNotify(message, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN);
            this.waitForState(AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void sendMessage(MessageDto message) {
            this.postMessageAndNotify(message, AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE);
        }

        private synchronized void postMessageAndNotify(MessageDto message, AbstractNodeAdapter.SessionManagerState targetState) {
            this.response = message;
            this.state = targetState;
            this.notifyAll();
        }
    }
}

