/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.ServerPushEventStrategyAdapter;
import org.eclipse.keyple.distributed.SyncNodeClient;
import org.eclipse.keyple.distributed.spi.SyncEndpointClientSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncNodeClientAdapter
extends AbstractNodeAdapter
implements SyncNodeClient {
    private static final Logger logger = LoggerFactory.getLogger(SyncNodeClientAdapter.class);
    private final SyncEndpointClientSpi endpoint;
    private final ServerPushEventStrategyAdapter pluginObservationStrategy;
    private EventObserver pluginEventObserver;
    private final Object pluginMonitor;
    private final ServerPushEventStrategyAdapter readerObservationStrategy;
    private EventObserver readerEventObserver;
    private final Object readerMonitor;
    private volatile int nbOfObservedReaders;

    SyncNodeClientAdapter(AbstractMessageHandlerAdapter handler, SyncEndpointClientSpi endpoint, ServerPushEventStrategyAdapter pluginObservationStrategy, ServerPushEventStrategyAdapter readerObservationStrategy) {
        super(handler, 0);
        this.endpoint = endpoint;
        this.pluginObservationStrategy = pluginObservationStrategy;
        this.pluginMonitor = new Object();
        this.readerObservationStrategy = readerObservationStrategy;
        this.readerMonitor = new Object();
        this.nbOfObservedReaders = 0;
    }

    @Override
    MessageDto sendRequest(MessageDto message) {
        message.setClientNodeId(this.getNodeId());
        List<MessageDto> responses = this.endpoint.sendRequest(message);
        if (responses == null || responses.isEmpty()) {
            return null;
        }
        if (responses.size() == 1) {
            MessageDto response = responses.get(0);
            Assert.getInstance().notNull((Object)response, "message").notEmpty(response.getSessionId(), "sessionId").notEmpty(response.getAction(), "action").notEmpty(response.getClientNodeId(), "clientNodeId").notEmpty(response.getServerNodeId(), "serverNodeId");
            return response;
        }
        throw new IllegalStateException(String.format("The list returned by the client endpoint should have contained a single element but contains %s elements.", responses.size()));
    }

    @Override
    void sendMessage(MessageDto message) {
        message.setClientNodeId(this.getNodeId());
        this.endpoint.sendRequest(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onStartPluginsObservation() {
        if (this.pluginObservationStrategy == null) {
            throw new IllegalStateException("The plugin observation strategy is not set.");
        }
        Object object = this.pluginMonitor;
        synchronized (object) {
            if (this.pluginEventObserver == null) {
                this.pluginEventObserver = new EventObserver(this.pluginObservationStrategy, MessageDto.Action.CHECK_PLUGIN_EVENT);
                this.pluginEventObserver.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onStopPluginsObservation() {
        Object object = this.pluginMonitor;
        synchronized (object) {
            if (this.pluginEventObserver != null) {
                this.pluginEventObserver.stop();
                this.pluginEventObserver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onStartReaderObservation() {
        if (this.readerObservationStrategy == null) {
            throw new IllegalStateException("The reader observation strategy is not set.");
        }
        Object object = this.readerMonitor;
        synchronized (object) {
            ++this.nbOfObservedReaders;
            if (this.readerEventObserver == null) {
                this.readerEventObserver = new EventObserver(this.readerObservationStrategy, MessageDto.Action.CHECK_READER_EVENT);
                this.readerEventObserver.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onStopReaderObservation() {
        Object object = this.readerMonitor;
        synchronized (object) {
            if (this.nbOfObservedReaders > 0) {
                --this.nbOfObservedReaders;
            }
            if (this.nbOfObservedReaders == 0 && this.readerEventObserver != null) {
                this.readerEventObserver.stop();
                this.readerEventObserver = null;
            }
        }
    }

    private class EventObserver {
        private final ServerPushEventStrategyAdapter strategy;
        private final MessageDto.Action action;
        private final MessageDto message;
        private final Thread thread;

        private EventObserver(ServerPushEventStrategyAdapter strategy, MessageDto.Action action) {
            this.strategy = strategy;
            this.action = action;
            this.message = this.buildMessage();
            this.thread = strategy.getType() == ServerPushEventStrategyAdapter.Type.POLLING ? new PollingEventObserver() : new LongPollingEventObserver();
            this.thread.setUncaughtExceptionHandler(new EventObserverUncaughtExceptionHandler());
            this.thread.setName(action.name());
        }

        private MessageDto buildMessage() {
            JsonObject body = new JsonObject();
            body.addProperty(MessageDto.JsonProperty.CORE_API_LEVEL.getKey(), (Number)SyncNodeClientAdapter.this.getHandler().getCoreApiLevel());
            body.addProperty(MessageDto.JsonProperty.STRATEGY.getKey(), this.strategy.getType().name());
            if (this.strategy.getType() == ServerPushEventStrategyAdapter.Type.LONG_POLLING) {
                body.addProperty(MessageDto.JsonProperty.DURATION.getKey(), (Number)this.strategy.getDurationMillis());
            }
            return new MessageDto().setSessionId(AbstractMessageHandlerAdapter.generateSessionId()).setAction(this.action.name()).setClientNodeId(SyncNodeClientAdapter.this.getNodeId()).setBody(body.toString());
        }

        private void checkForEvents() {
            List<MessageDto> responses;
            try {
                responses = SyncNodeClientAdapter.this.endpoint.sendRequest(this.message);
            }
            catch (Exception e) {
                logger.error("Server connection error", (Throwable)e);
                responses = this.retryRequest();
            }
            if (responses != null && !responses.isEmpty()) {
                for (MessageDto event : responses) {
                    SyncNodeClientAdapter.this.getHandler().onMessage(event);
                }
            }
        }

        private List<MessageDto> retryRequest() {
            int timer1 = 0;
            int timer2 = 1000;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    int timer = timer1 + timer2;
                    Thread.sleep(timer);
                    logger.info("Retry to send request after {} seconds...", (Object)(timer / 1000));
                    List<MessageDto> responses = this.sendRequestSilently();
                    if (responses != null) {
                        logger.info("Server connection retrieved");
                        return responses;
                    }
                    timer1 = timer2;
                    timer2 = timer;
                }
                catch (InterruptedException e) {
                    logger.error("Unexpected interruption of thread {}", (Object)Thread.currentThread().getName(), (Object)e);
                    Thread.currentThread().interrupt();
                }
            }
            return new ArrayList<MessageDto>();
        }

        private List<MessageDto> sendRequestSilently() {
            try {
                return SyncNodeClientAdapter.this.endpoint.sendRequest(this.message);
            }
            catch (Exception e) {
                return null;
            }
        }

        private void start() {
            this.thread.start();
        }

        private void stop() {
            this.thread.interrupt();
        }

        private class EventObserverUncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private EventObserverUncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Interruption of thread {} caused by an unhandled exception", (Object)t.getName(), (Object)e);
            }
        }

        private class LongPollingEventObserver
        extends Thread {
            private LongPollingEventObserver() {
            }

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    EventObserver.this.checkForEvents();
                }
            }
        }

        private class PollingEventObserver
        extends Thread {
            private PollingEventObserver() {
            }

            @Override
            public void run() {
                int requestFrequencyMillis = EventObserver.this.strategy.getDurationMillis();
                while (!Thread.currentThread().isInterrupted()) {
                    EventObserver.this.checkForEvents();
                    try {
                        Thread.sleep(requestFrequencyMillis);
                    }
                    catch (InterruptedException e) {
                        logger.error("Unexpected interruption of thread {}", (Object)this.getName(), (Object)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

