/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.AsyncNodeServer;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServerSpi;

final class AsyncNodeServerAdapter
extends AbstractNodeAdapter
implements AsyncNodeServer {
    private static final String SESSION_ID = "sessionId";
    private final AsyncEndpointServerSpi endpoint;
    private final Map<String, SessionManager> sessionManagers;

    AsyncNodeServerAdapter(AbstractMessageHandlerAdapter handler, AsyncEndpointServerSpi endpoint, int timeoutSeconds) {
        super(handler, timeoutSeconds);
        this.endpoint = endpoint;
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
    }

    @Override
    MessageDto sendRequest(MessageDto message) {
        message.setServerNodeId(this.getNodeId());
        SessionManager manager = this.getManagerForHandler(message.getSessionId());
        return manager.sendRequest(message);
    }

    @Override
    void sendMessage(MessageDto message) {
        message.setServerNodeId(this.getNodeId());
        SessionManager manager = this.getManagerForHandler(message.getSessionId());
        manager.sendMessage(message);
    }

    private SessionManager getManagerForHandler(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        if (manager == null) {
            throw new IllegalStateException(String.format("The node's session '%s' is closed.", sessionId));
        }
        return manager;
    }

    @Override
    public void onMessage(MessageDto message) {
        Assert.getInstance().notNull((Object)message, "message").notEmpty(message.getSessionId(), SESSION_ID).notEmpty(message.getAction(), "action").notEmpty(message.getClientNodeId(), "clientNodeId");
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        if (manager == null) {
            manager = new SessionManager(message.getSessionId());
            this.sessionManagers.put(message.getSessionId(), manager);
        }
        manager.onMessage(message);
    }

    @Override
    public void onError(String sessionId, Throwable error) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID).notNull((Object)error, "error");
        SessionManager manager = this.sessionManagers.get(sessionId);
        Assert.getInstance().notNull((Object)manager, SESSION_ID);
        manager.onError(error);
    }

    @Override
    public void onClose(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.sessionManagers.remove(sessionId);
        Assert.getInstance().notNull((Object)manager, SESSION_ID);
    }

    private class SessionManager
    extends AbstractNodeAdapter.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
            if (this.state == AbstractNodeAdapter.SessionManagerState.EXTERNAL_ERROR_OCCURRED) {
                this.state = AbstractNodeAdapter.SessionManagerState.ABORTED_SESSION;
                throw new NodeCommunicationException(this.error.getMessage(), this.error);
            }
        }

        private synchronized void onMessage(MessageDto message) {
            this.checkState(AbstractNodeAdapter.SessionManagerState.INITIALIZED, AbstractNodeAdapter.SessionManagerState.ON_MESSAGE, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END, AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE);
            if (this.state == AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN) {
                this.response = message;
                this.state = AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END;
                this.notifyAll();
            } else {
                this.state = AbstractNodeAdapter.SessionManagerState.ON_MESSAGE;
                AsyncNodeServerAdapter.this.getHandler().onMessage(message);
            }
        }

        private synchronized MessageDto sendRequest(MessageDto message) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN;
            this.response = null;
            AsyncNodeServerAdapter.this.endpoint.sendMessage(message);
            this.waitForState(AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void sendMessage(MessageDto message) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE;
            AsyncNodeServerAdapter.this.endpoint.sendMessage(message);
            this.checkIfExternalErrorOccurred();
        }

        private synchronized void onError(Throwable e) {
            this.checkState(AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE);
            this.error = e;
            this.state = AbstractNodeAdapter.SessionManagerState.EXTERNAL_ERROR_OCCURRED;
            this.notifyAll();
        }
    }
}

