/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.AsyncNodeClient;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClientSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncNodeClientAdapter
extends AbstractNodeAdapter
implements AsyncNodeClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncNodeClientAdapter.class);
    private static final String SESSION_ID = "sessionId";
    private final AsyncEndpointClientSpi endpoint;
    private final Map<String, SessionManager> sessionManagers;

    AsyncNodeClientAdapter(AbstractMessageHandlerAdapter handler, AsyncEndpointClientSpi endpoint, int timeoutSeconds) {
        super(handler, timeoutSeconds);
        this.endpoint = endpoint;
        this.sessionManagers = new ConcurrentHashMap<String, SessionManager>();
    }

    @Override
    void openSession(String sessionId) {
        SessionManager manager = new SessionManager(sessionId);
        this.sessionManagers.put(sessionId, manager);
        manager.openSession();
    }

    @Override
    public void onOpen(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onOpen();
        }
    }

    @Override
    MessageDto sendRequest(MessageDto message) {
        message.setClientNodeId(this.getNodeId());
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        return manager.sendRequest(message);
    }

    @Override
    void sendMessage(MessageDto message) {
        message.setClientNodeId(this.getNodeId());
        SessionManager manager = this.sessionManagers.get(message.getSessionId());
        manager.sendMessage(message);
    }

    @Override
    public void onMessage(MessageDto message) {
        Assert.getInstance().notNull((Object)message, "message").notEmpty(message.getSessionId(), SESSION_ID).notEmpty(message.getAction(), "action").notEmpty(message.getClientNodeId(), "clientNodeId").notEmpty(message.getServerNodeId(), "serverNodeId");
        SessionManager manager = this.getManagerForEndpoint(message.getSessionId());
        if (manager != null) {
            MessageDto.Action action = MessageDto.Action.valueOf(message.getAction());
            switch (action) {
                case PLUGIN_EVENT: 
                case READER_EVENT: {
                    manager.onEvent(message);
                    break;
                }
                default: {
                    manager.onResponse(message);
                }
            }
        }
    }

    @Override
    void closeSession(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        try {
            manager.closeSession();
        }
        finally {
            this.sessionManagers.remove(sessionId);
        }
    }

    @Override
    public void onClose(String sessionId) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID);
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onClose();
        }
    }

    @Override
    public void onError(String sessionId, Throwable error) {
        Assert.getInstance().notEmpty(sessionId, SESSION_ID).notNull((Object)error, "error");
        SessionManager manager = this.getManagerForEndpoint(sessionId);
        if (manager != null) {
            manager.onError(error);
        }
    }

    private SessionManager getManagerForEndpoint(String sessionId) {
        SessionManager manager = this.sessionManagers.get(sessionId);
        if (manager == null) {
            logger.warn("The node's session '{}' is not found. It was maybe closed due to a timeout.", (Object)sessionId);
        }
        return manager;
    }

    private class SessionManager
    extends AbstractNodeAdapter.AbstractSessionManager {
        private SessionManager(String sessionId) {
            super(sessionId);
        }

        @Override
        void checkIfExternalErrorOccurred() {
            if (this.state == AbstractNodeAdapter.SessionManagerState.EXTERNAL_ERROR_OCCURRED) {
                this.state = AbstractNodeAdapter.SessionManagerState.ABORTED_SESSION;
                throw new NodeCommunicationException(this.error.getMessage(), this.error);
            }
        }

        private synchronized void openSession() {
            this.state = AbstractNodeAdapter.SessionManagerState.OPEN_SESSION_BEGIN;
            AsyncNodeClientAdapter.this.endpoint.openSession(this.sessionId);
            this.waitForState(AbstractNodeAdapter.SessionManagerState.OPEN_SESSION_END);
        }

        private synchronized void onOpen() {
            this.checkState(AbstractNodeAdapter.SessionManagerState.OPEN_SESSION_BEGIN);
            this.state = AbstractNodeAdapter.SessionManagerState.OPEN_SESSION_END;
            this.notifyAll();
        }

        private synchronized MessageDto sendRequest(MessageDto message) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN;
            this.response = null;
            AsyncNodeClientAdapter.this.endpoint.sendMessage(message);
            this.waitForState(AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END);
            return this.response;
        }

        private synchronized void onResponse(MessageDto message) {
            this.checkState(AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN);
            this.response = message;
            this.state = AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_END;
            this.notifyAll();
        }

        private void onEvent(MessageDto message) {
            AsyncNodeClientAdapter.this.getHandler().onMessage(message);
        }

        private synchronized void sendMessage(MessageDto message) {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE;
            AsyncNodeClientAdapter.this.endpoint.sendMessage(message);
            this.checkIfExternalErrorOccurred();
        }

        private synchronized void closeSession() {
            this.checkIfExternalErrorOccurred();
            this.state = AbstractNodeAdapter.SessionManagerState.CLOSE_SESSION_BEGIN;
            AsyncNodeClientAdapter.this.endpoint.closeSession(this.sessionId);
            this.waitForState(AbstractNodeAdapter.SessionManagerState.CLOSE_SESSION_END);
        }

        private synchronized void onClose() {
            this.checkState(AbstractNodeAdapter.SessionManagerState.CLOSE_SESSION_BEGIN);
            this.state = AbstractNodeAdapter.SessionManagerState.CLOSE_SESSION_END;
            this.notifyAll();
        }

        private synchronized void onError(Throwable e) {
            this.checkState(AbstractNodeAdapter.SessionManagerState.OPEN_SESSION_BEGIN, AbstractNodeAdapter.SessionManagerState.SEND_REQUEST_BEGIN, AbstractNodeAdapter.SessionManagerState.SEND_MESSAGE, AbstractNodeAdapter.SessionManagerState.CLOSE_SESSION_BEGIN);
            this.error = e;
            this.state = AbstractNodeAdapter.SessionManagerState.EXTERNAL_ERROR_OCCURRED;
            this.notifyAll();
        }
    }
}

