/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.eclipse.keyple.distributed.AbstractMessageHandlerAdapter;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.NodeCommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNodeAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNodeAdapter.class);
    private final String nodeId = UUID.randomUUID().toString();
    private final AbstractMessageHandlerAdapter handler;
    private final int timeoutMillis;

    AbstractNodeAdapter(AbstractMessageHandlerAdapter handler, int timeoutSeconds) {
        this.handler = handler;
        this.timeoutMillis = timeoutSeconds * 1000;
    }

    final String getNodeId() {
        return this.nodeId;
    }

    final AbstractMessageHandlerAdapter getHandler() {
        return this.handler;
    }

    void openSession(String sessionId) {
    }

    abstract MessageDto sendRequest(MessageDto var1);

    abstract void sendMessage(MessageDto var1);

    void closeSession(String sessionId) {
    }

    final void closeSessionSilently(String sessionId) {
        try {
            this.closeSession(sessionId);
        }
        catch (RuntimeException e) {
            logger.error("Error during the silent closing of node's session [{}] : {}", new Object[]{sessionId, e.getMessage(), e});
        }
    }

    void onStartPluginsObservation() {
    }

    void onStopPluginsObservation() {
    }

    void onStartReaderObservation() {
    }

    void onStopReaderObservation() {
    }

    abstract class AbstractSessionManager {
        final String sessionId;
        volatile SessionManagerState state;
        MessageDto response;
        Throwable error;

        AbstractSessionManager(String sessionId) {
            this.sessionId = sessionId;
            this.state = SessionManagerState.INITIALIZED;
            this.response = null;
            this.error = null;
        }

        synchronized void waitForState(SessionManagerState ... targetStates) {
            for (SessionManagerState targetState : targetStates) {
                if (this.state != targetState) continue;
                return;
            }
            this.checkIfExternalErrorOccurred();
            try {
                long deadline = new Date().getTime() + (long)AbstractNodeAdapter.this.timeoutMillis;
                while (new Date().getTime() < deadline) {
                    this.wait(AbstractNodeAdapter.this.timeoutMillis);
                    for (SessionManagerState targetState : targetStates) {
                        if (this.state != targetState) continue;
                        return;
                    }
                    this.checkIfExternalErrorOccurred();
                }
                this.timeoutOccurred();
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption of the task associated with the node's session {}", (Object)this.sessionId, (Object)e);
                Thread.currentThread().interrupt();
            }
        }

        abstract void checkIfExternalErrorOccurred();

        void checkState(SessionManagerState ... targetStates) {
            for (SessionManagerState targetState : targetStates) {
                if (this.state != targetState) continue;
                return;
            }
            throw new IllegalStateException(String.format("The status of the node's session manager '%s' should have been one of %s, but is currently '%s'", new Object[]{this.sessionId, Arrays.toString((Object[])targetStates), this.state}));
        }

        void timeoutOccurred() {
            this.state = SessionManagerState.ABORTED_SESSION;
            logger.error("Timeout occurs for the task associated with the node's session '{}'", (Object)this.sessionId);
            throw new NodeCommunicationException(String.format("Timeout occurs for the task associated with the node's session '%s'", this.sessionId));
        }
    }

    static enum SessionManagerState {
        INITIALIZED,
        OPEN_SESSION_BEGIN,
        OPEN_SESSION_END,
        ON_REQUEST,
        ON_MESSAGE,
        SEND_REQUEST_BEGIN,
        SEND_REQUEST_END,
        SEND_MESSAGE,
        EXTERNAL_ERROR_OCCURRED,
        CLOSE_SESSION_BEGIN,
        CLOSE_SESSION_END,
        ABORTED_SESSION;

    }
}

