/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import java.util.UUID;
import org.eclipse.keyple.core.util.json.BodyError;
import org.eclipse.keyple.core.util.json.JsonUtil;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.AsyncNodeClientAdapter;
import org.eclipse.keyple.distributed.AsyncNodeServerAdapter;
import org.eclipse.keyple.distributed.MessageDto;
import org.eclipse.keyple.distributed.ServerPushEventStrategyAdapter;
import org.eclipse.keyple.distributed.SyncNodeClientAdapter;
import org.eclipse.keyple.distributed.SyncNodeServerAdapter;
import org.eclipse.keyple.distributed.spi.AsyncEndpointClientSpi;
import org.eclipse.keyple.distributed.spi.AsyncEndpointServerSpi;
import org.eclipse.keyple.distributed.spi.SyncEndpointClientSpi;

abstract class AbstractMessageHandlerAdapter {
    private AbstractNodeAdapter node;
    private boolean isBoundToSyncNode;
    private int coreApiLevel;

    AbstractMessageHandlerAdapter() {
    }

    static String generateSessionId() {
        return UUID.randomUUID().toString();
    }

    static void checkError(MessageDto message) {
        if (message.getAction().equals(MessageDto.Action.ERROR.name())) {
            throw new RuntimeException(((BodyError)JsonUtil.getParser().fromJson(message.getBody(), BodyError.class)).getException());
        }
    }

    final void setCoreApiLevel(int coreApiLevel) {
        this.coreApiLevel = coreApiLevel;
    }

    final int getCoreApiLevel() {
        return this.coreApiLevel;
    }

    final void bindSyncNodeClient(SyncEndpointClientSpi endpoint, ServerPushEventStrategyAdapter pluginObservationStrategy, ServerPushEventStrategyAdapter readerObservationStrategy) {
        this.node = new SyncNodeClientAdapter(this, endpoint, pluginObservationStrategy, readerObservationStrategy);
        this.isBoundToSyncNode = true;
    }

    final void bindSyncNodeServer() {
        this.node = new SyncNodeServerAdapter(this, 20);
        this.isBoundToSyncNode = true;
    }

    final void bindAsyncNodeClient(AsyncEndpointClientSpi endpoint, int timeoutSeconds) {
        this.node = new AsyncNodeClientAdapter(this, endpoint, timeoutSeconds);
        this.isBoundToSyncNode = false;
    }

    final void bindAsyncNodeServer(AsyncEndpointServerSpi endpoint) {
        this.node = new AsyncNodeServerAdapter(this, endpoint, 20);
        this.isBoundToSyncNode = false;
    }

    final AbstractNodeAdapter getNode() {
        return this.node;
    }

    final boolean isBoundToSyncNode() {
        return this.isBoundToSyncNode;
    }

    abstract void onMessage(MessageDto var1);
}

