/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.mongodb;

import jakarta.nosql.document.Document;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import jakarta.nosql.mapping.document.DocumentEventPersistManager;
import jakarta.nosql.mapping.document.DocumentWorkflow;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.mongodb.document.MongoDBDocumentManager;
import org.eclipse.jnosql.mapping.document.AbstractDocumentTemplate;
import org.eclipse.jnosql.mapping.mongodb.MongoDBTemplate;
import org.eclipse.jnosql.mapping.mongodb.criteria.CriteriaQueryUtils;
import org.eclipse.jnosql.mapping.mongodb.criteria.DefaultCriteriaQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.CriteriaQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.CriteriaQueryResult;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.EntityQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.ExecutableQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.ExpressionQuery;
import org.eclipse.jnosql.mapping.mongodb.criteria.api.SelectQuery;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

@ApplicationScoped
@Typed(value={MongoDBTemplate.class})
class DefaultMongoDBTemplate
extends AbstractDocumentTemplate
implements MongoDBTemplate {
    private Instance<MongoDBDocumentManager> manager;
    private DocumentEntityConverter converter;
    private DocumentWorkflow workflow;
    private EntitiesMetadata entities;
    private Converters converters;
    private DocumentEventPersistManager persistManager;

    @Deprecated
    DefaultMongoDBTemplate() {
    }

    DefaultMongoDBTemplate(Instance<MongoDBDocumentManager> manager, DocumentEntityConverter converter, DocumentWorkflow workflow, EntitiesMetadata entities, Converters converters, DocumentEventPersistManager persistManager) {
        this.manager = manager;
        this.converter = converter;
        this.workflow = workflow;
        this.entities = entities;
        this.converters = converters;
        this.persistManager = persistManager;
    }

    protected DocumentEntityConverter getConverter() {
        return this.converter;
    }

    protected MongoDBDocumentManager getManager() {
        return (MongoDBDocumentManager)this.manager.get();
    }

    protected DocumentWorkflow getWorkflow() {
        return this.workflow;
    }

    protected DocumentEventPersistManager getEventManager() {
        return this.persistManager;
    }

    protected EntitiesMetadata getEntities() {
        return this.entities;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public long delete(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        return this.getManager().delete(collectionName, filter);
    }

    @Override
    public <T> long delete(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "Entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.getManager().delete(entityMetadata.getName(), filter);
    }

    @Override
    public <T> Stream<T> select(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        Stream entityStream = this.getManager().select(collectionName, filter);
        return entityStream.map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public <T> Stream<T> select(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        Stream entityStream = this.getManager().select(entityMetadata.getName(), filter);
        return entityStream.map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public Stream<Map<String, BsonValue>> aggregate(String collectionName, List<Bson> pipeline) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        return this.getManager().aggregate(collectionName, pipeline);
    }

    @Override
    public <T> Stream<Map<String, BsonValue>> aggregate(Class<T> entity, List<Bson> pipeline) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.getManager().aggregate(entityMetadata.getName(), pipeline);
    }

    @Override
    public <T> CriteriaQuery<T> createQuery(Class<T> type) {
        return new DefaultCriteriaQuery<T>(type);
    }

    @Override
    public <T, R extends CriteriaQueryResult<T>, Q extends ExecutableQuery<T, R, Q, F>, F> R executeQuery(ExecutableQuery<T, R, Q, F> criteriaQuery) {
        Objects.requireNonNull(criteriaQuery, "query is required");
        if (criteriaQuery instanceof SelectQuery) {
            SelectQuery selectQuery = (SelectQuery)SelectQuery.class.cast(criteriaQuery);
            DocumentQuery documentQuery = CriteriaQueryUtils.convert(selectQuery);
            this.getEventManager().firePreQuery(documentQuery);
            Stream entityStream = this.getManager().select(documentQuery);
            if (selectQuery instanceof EntityQuery) {
                ((EntityQuery)EntityQuery.class.cast(selectQuery)).feed(entityStream.map(documentEntity -> this.getConverter().toEntity(documentEntity)));
            } else if (selectQuery instanceof ExpressionQuery) {
                ((ExpressionQuery)ExpressionQuery.class.cast(selectQuery)).feed(entityStream.map(documentEntity -> documentEntity.getDocuments().stream().map(Document::getValue).collect(Collectors.toList())));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return criteriaQuery.getResult();
    }
}

