/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import java.util.Objects;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.CustomRepositoryHandler;

public class CustomRepositoryHandlerBuilder {
    private EntitiesMetadata entitiesMetadata;
    private SemiStructuredTemplate template;
    private Class<?> customRepositoryType;
    private Converters converters;

    public CustomRepositoryHandlerBuilder entitiesMetadata(EntitiesMetadata entitiesMetadata) {
        this.entitiesMetadata = Objects.requireNonNull(entitiesMetadata, "entitiesMetadata is required");
        return this;
    }

    public CustomRepositoryHandlerBuilder template(SemiStructuredTemplate template) {
        this.template = Objects.requireNonNull(template, "template is required");
        return this;
    }

    public CustomRepositoryHandlerBuilder customRepositoryType(Class<?> customRepositoryType) {
        this.customRepositoryType = Objects.requireNonNull(customRepositoryType, "customRepositoryType is required");
        return this;
    }

    public CustomRepositoryHandlerBuilder converters(Converters converters) {
        this.converters = Objects.requireNonNull(converters, "converters is required");
        return this;
    }

    public CustomRepositoryHandler build() {
        return new CustomRepositoryHandler(this.entitiesMetadata, this.template, this.customRepositoryType, this.converters);
    }
}

