/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import jakarta.data.repository.Find;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Query;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.QueryType;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.core.repository.DynamicQueryMethodReturn;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.RepositoryReflectionUtils;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.PreparedStatement;
import org.eclipse.jnosql.mapping.semistructured.query.BaseSemiStructuredRepository;
import org.eclipse.jnosql.mapping.semistructured.query.SemiStructuredParameterBasedQuery;

public abstract class AbstractSemiStructuredRepositoryProxy<T, K>
extends BaseSemiStructuredRepository<T, K> {
    private static final Logger LOGGER = Logger.getLogger(AbstractSemiStructuredRepositoryProxy.class.getName());

    protected Object executeQuery(Object instance, Method method, Object[] params) {
        LOGGER.finest("Executing query on method: " + method);
        Class type = this.entityMetadata().type();
        String entity = this.entityMetadata().name();
        PageRequest pageRequest = DynamicReturn.findPageRequest((Object[])params);
        String queryValue = method.getAnnotation(Query.class).value();
        QueryType queryType = QueryType.parse((String)queryValue);
        Class<?> returnType = method.getReturnType();
        LOGGER.finest("Query: " + queryValue + " with type: " + queryType + " and return type: " + returnType);
        queryType.checkValidReturn(returnType, queryValue);
        DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().args(params).method(method).typeClass(type).pageRequest(pageRequest).prepareConverter(textQuery -> {
            PreparedStatement prepare = (PreparedStatement)this.template().prepare((String)textQuery, entity);
            prepare.setSelectMapper(query -> this.updateQueryDynamically(params, (SelectQuery)query));
            return prepare;
        }).build();
        return methodReturn.execute();
    }

    protected Object executeCursorPagination(Object instance, Method method, Object[] params) {
        if (method.getAnnotation(Query.class) != null) {
            String entity = this.entityMetadata().name();
            String textQuery = method.getAnnotation(Query.class).value();
            PreparedStatement prepare = (PreparedStatement)this.template().prepare(textQuery, entity);
            Map argsParams = RepositoryReflectionUtils.INSTANCE.getParams(method, params);
            argsParams.forEach(prepare::bind);
            SelectQuery selectQuery = this.updateQueryDynamically(params, prepare.selectQuery().orElseThrow());
            SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])params, this.sortParser());
            PageRequest pageRequest = (PageRequest)special.pageRequest().orElseThrow(() -> new IllegalArgumentException("Pageable is required in the method signature as parameter at " + method));
            return this.template().selectCursor(selectQuery, pageRequest);
        }
        if (method.getAnnotation(Find.class) == null) {
            SelectQuery query = this.query(method, params);
            SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])params, this.sortParser());
            PageRequest pageRequest = (PageRequest)special.pageRequest().orElseThrow(() -> new IllegalArgumentException("Pageable is required in the method signature as parameter at " + method));
            return this.template().selectCursor(query, pageRequest);
        }
        Map parameters = RepositoryReflectionUtils.INSTANCE.getBy(method, params);
        SelectQuery query = SemiStructuredParameterBasedQuery.INSTANCE.toQuery(parameters, AbstractSemiStructuredRepositoryProxy.getSorts(method, this.entityMetadata()), this.entityMetadata());
        SelectQuery updateQuery = this.updateQueryDynamically(params, query);
        SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])params, this.sortParser());
        PageRequest pageRequest = (PageRequest)special.pageRequest().orElseThrow(() -> new IllegalArgumentException("Pageable is required in the method signature as parameter at " + method));
        return this.template().selectCursor(updateQuery, pageRequest);
    }

    protected Object executeDeleteByAll(Object instance, Method method, Object[] params) {
        DeleteQuery deleteQuery = this.deleteQuery(method, params);
        this.template().delete(deleteQuery);
        return Void.class;
    }

    protected Object executeFindAll(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        SelectQuery query = SelectQuery.select().from(this.entityMetadata().name()).build();
        return this.executeFindByQuery(method, params, type, this.updateQueryDynamically(params, query));
    }

    protected Object executeExistByQuery(Object instance, Method method, Object[] params) {
        return this.executeExistsByQuery(this.query(method, params));
    }

    protected Object executeCountByQuery(Object instance, Method method, Object[] params) {
        return this.executeCountByQuery(this.query(method, params));
    }

    protected Object executeFindByQuery(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        return this.executeFindByQuery(method, params, type, this.query(method, params));
    }

    protected Object executeParameterBased(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        Map parameters = RepositoryReflectionUtils.INSTANCE.getBy(method, params);
        SelectQuery query = SemiStructuredParameterBasedQuery.INSTANCE.toQuery(parameters, AbstractSemiStructuredRepositoryProxy.getSorts(method, this.entityMetadata()), this.entityMetadata());
        return this.executeFindByQuery(method, params, type, this.updateQueryDynamically(params, query));
    }

    private static List<Sort<?>> getSorts(Method method, EntityMetadata metadata) {
        return Stream.of((OrderBy[])method.getAnnotationsByType(OrderBy.class)).map(order -> {
            String column = metadata.columnField(order.value());
            if (column == null || column.isEmpty()) {
                throw new IllegalArgumentException("Invalid field in @OrderBy: " + order.value());
            }
            return order.descending() ? Sort.desc((String)column) : Sort.asc((String)column);
        }).collect(Collectors.toList());
    }
}

