/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.data.Direction;
import jakarta.data.Sort;
import jakarta.nosql.QueryMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.AbstractMapperQuery;
import org.eclipse.jnosql.mapping.semistructured.MappingQuery;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;

final class MapperSelect
extends AbstractMapperQuery
implements QueryMapper.MapperFrom,
QueryMapper.MapperLimit,
QueryMapper.MapperSkip,
QueryMapper.MapperOrder,
QueryMapper.MapperNameCondition,
QueryMapper.MapperNotCondition,
QueryMapper.MapperNameOrder,
QueryMapper.MapperWhere {
    private final List<Sort<?>> sorts = new ArrayList();

    MapperSelect(EntityMetadata mapping, Converters converters, SemiStructuredTemplate template) {
        super(mapping, converters, template);
    }

    public QueryMapper.MapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public QueryMapper.MapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public QueryMapper.MapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperSkip skip(long start) {
        this.start = start;
        return this;
    }

    public QueryMapper.MapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public QueryMapper.MapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> QueryMapper.MapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public QueryMapper.MapperWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> QueryMapper.MapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public QueryMapper.MapperNameOrder asc() {
        this.sorts.add(Sort.of((String)this.mapping.columnField(this.name), (Direction)Direction.ASC, (boolean)false));
        return this;
    }

    public QueryMapper.MapperNameOrder desc() {
        this.sorts.add(Sort.of((String)this.mapping.columnField(this.name), (Direction)Direction.DESC, (boolean)false));
        return this;
    }

    private SelectQuery build() {
        return new MappingQuery(this.sorts, this.limit, this.start, this.condition, this.entity);
    }

    public <T> List<T> result() {
        SelectQuery query = this.build();
        return this.template.select(query).toList();
    }

    public <T> Stream<T> stream() {
        SelectQuery query = this.build();
        return this.template.select(query);
    }

    public <T> Optional<T> singleResult() {
        SelectQuery query = this.build();
        return this.template.singleResult(query);
    }
}

