/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.util.ConverterUtil;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;

abstract class AbstractMapperQuery {
    protected final String entity;
    protected boolean negate;
    protected CriteriaCondition condition;
    protected boolean and;
    protected String name;
    protected final transient EntityMetadata mapping;
    protected final transient Converters converters;
    protected final transient SemiStructuredTemplate template;
    protected long start;
    protected long limit;

    AbstractMapperQuery(EntityMetadata mapping, Converters converters, SemiStructuredTemplate template) {
        this.mapping = mapping;
        this.converters = converters;
        this.entity = mapping.name();
        this.template = template;
        mapping.inheritance().ifPresent(i -> {
            if (!i.parent().equals(mapping.type())) {
                this.condition = CriteriaCondition.eq((Element)Element.of((String)i.discriminatorColumn(), (Object)i.discriminatorValue()));
                this.and = true;
            }
        });
    }

    protected void appendCondition(CriteriaCondition incomingCondition) {
        CriteriaCondition columnCondition = this.getCondition(incomingCondition);
        this.condition = Objects.nonNull(this.condition) ? (this.and ? this.condition.and(columnCondition) : this.condition.or(columnCondition)) : columnCondition;
        this.negate = false;
        this.name = null;
    }

    protected <T> void betweenImpl(T valueA, T valueB) {
        Objects.requireNonNull(valueA, "valueA is required");
        Objects.requireNonNull(valueB, "valueB is required");
        CriteriaCondition newCondition = CriteriaCondition.between((Element)Element.of((String)this.mapping.columnField(this.name), Arrays.asList(this.getValue(valueA), this.getValue(valueB))));
        this.appendCondition(newCondition);
    }

    protected <T> void inImpl(Iterable<T> values) {
        Objects.requireNonNull(values, "values is required");
        List convertedValues = StreamSupport.stream(values.spliterator(), false).map(this::getValue).collect(Collectors.toList());
        CriteriaCondition newCondition = CriteriaCondition.in((Element)Element.of((String)this.mapping.columnField(this.name), convertedValues));
        this.appendCondition(newCondition);
    }

    protected <T> void eqImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.eq((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected void likeImpl(String value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.like((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.gte((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void gtImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.gt((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void ltImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.lt((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected <T> void lteImpl(T value) {
        Objects.requireNonNull(value, "value is required");
        CriteriaCondition newCondition = CriteriaCondition.lte((Element)Element.of((String)this.mapping.columnField(this.name), (Object)this.getValue(value)));
        this.appendCondition(newCondition);
    }

    protected Object getValue(Object value) {
        return ConverterUtil.getValue((Object)value, (EntityMetadata)this.mapping, (String)this.name, (Converters)this.converters);
    }

    private CriteriaCondition getCondition(CriteriaCondition newCondition) {
        if (this.negate) {
            return newCondition.negate();
        }
        return newCondition;
    }
}

