/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.CommunicationPreparedStatement;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.MapperObserver;
import org.eclipse.jnosql.mapping.semistructured.SelectFieldMapper;

public final class PreparedStatement
implements org.eclipse.jnosql.mapping.PreparedStatement {
    private final CommunicationPreparedStatement preparedStatement;
    private final EntityConverter converter;
    private final MapperObserver observer;
    private final EntitiesMetadata entitiesMetadata;

    PreparedStatement(CommunicationPreparedStatement preparedStatement, EntityConverter converter, MapperObserver observer, EntitiesMetadata entitiesMetadata) {
        this.preparedStatement = preparedStatement;
        this.converter = converter;
        this.observer = observer;
        this.entitiesMetadata = entitiesMetadata;
    }

    public org.eclipse.jnosql.mapping.PreparedStatement bind(String name, Object value) {
        this.preparedStatement.bind(name, value);
        return this;
    }

    public <T> Stream<T> result() {
        Function fieldMapper = SelectFieldMapper.INSTANCE.map(this.observer, this.entitiesMetadata);
        return this.preparedStatement.result().map(this.converter::toEntity).map(fieldMapper);
    }

    public <T> Optional<T> singleResult() {
        Optional singleResult = this.preparedStatement.singleResult();
        Optional<Object> result = singleResult.map(this.converter::toEntity);
        return result.map(SelectFieldMapper.INSTANCE.map(this.observer, this.entitiesMetadata));
    }

    public long count() {
        return this.preparedStatement.count();
    }

    public boolean isCount() {
        return this.selectQuery().map(SelectQuery::isCount).orElse(false);
    }

    public Optional<SelectQuery> selectQuery() {
        return this.preparedStatement.select();
    }

    public void setSelectMapper(UnaryOperator<SelectQuery> selectMapper) {
        Objects.requireNonNull(selectMapper, "selectMapper is required");
        this.preparedStatement.setSelectMapper(selectMapper);
    }
}

