/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Limit;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.method.DeleteMethodProvider;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;
import org.eclipse.jnosql.communication.semistructured.CommunicationObserverParser;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.DeleteQueryParams;
import org.eclipse.jnosql.communication.semistructured.DeleteQueryParser;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.communication.semistructured.QueryParams;
import org.eclipse.jnosql.communication.semistructured.SelectQueryParser;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.query.AbstractRepositoryProxy;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.core.util.ParamsBinder;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.semistructured.MappingQuery;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.RepositorySemiStructuredObserverParser;

public abstract class BaseSemiStructuredRepository<T, K>
extends AbstractRepositoryProxy<T, K> {
    private static final SelectQueryParser SELECT_PARSER = new SelectQueryParser();
    private static final DeleteQueryParser DELETE_PARSER = new DeleteQueryParser();
    private static final Object[] EMPTY_PARAM = new Object[0];
    private CommunicationObserverParser parser;
    private ParamsBinder paramsBinder;

    protected abstract Converters converters();

    protected abstract EntityMetadata entityMetadata();

    protected abstract SemiStructuredTemplate template();

    protected org.eclipse.jnosql.communication.semistructured.SelectQuery query(Method method, Object[] args) {
        SelectMethodProvider provider = SelectMethodProvider.INSTANCE;
        SelectQuery selectQuery = provider.apply(method, this.entityMetadata().name());
        QueryParams queryParams = SELECT_PARSER.apply(selectQuery, this.parser());
        org.eclipse.jnosql.communication.semistructured.SelectQuery query = queryParams.query();
        Params params = queryParams.params();
        this.paramsBinder().bind(params, BaseSemiStructuredRepository.args(args), method);
        return this.updateQueryDynamically(BaseSemiStructuredRepository.args(args), query);
    }

    private static Object[] args(Object[] args) {
        return args == null ? EMPTY_PARAM : args;
    }

    protected DeleteQuery deleteQuery(Method method, Object[] args) {
        DeleteMethodProvider deleteMethodFactory = DeleteMethodProvider.INSTANCE;
        org.eclipse.jnosql.communication.query.DeleteQuery deleteQuery = deleteMethodFactory.apply(method, this.entityMetadata().name());
        DeleteQueryParams queryParams = DELETE_PARSER.apply(deleteQuery, this.parser());
        DeleteQuery query = queryParams.query();
        Params params = queryParams.params();
        this.paramsBinder().bind(params, BaseSemiStructuredRepository.args(args), method);
        return query;
    }

    protected CommunicationObserverParser parser() {
        if (this.parser == null) {
            this.parser = new RepositorySemiStructuredObserverParser(this.entityMetadata());
        }
        return this.parser;
    }

    protected ParamsBinder paramsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.entityMetadata(), this.converters());
        }
        return this.paramsBinder;
    }

    protected Object executeFindByQuery(Method method, Object[] args, Class<?> typeClass, org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        DynamicReturn dynamicReturn = DynamicReturn.builder().classSource(typeClass).methodSource(method).result(() -> this.template().select(query)).singleResult(() -> this.template().singleResult(query)).pagination(DynamicReturn.findPageRequest((Object[])args)).streamPagination(this.streamPagination(query)).singleResultPagination(this.getSingleResult(query)).page(this.getPage(query)).build();
        return dynamicReturn.execute();
    }

    private org.eclipse.jnosql.communication.semistructured.SelectQuery includeInheritance(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        InheritanceMetadata inheritanceMetadata;
        EntityMetadata metadata = this.entityMetadata();
        if (metadata.inheritance().isPresent() && !(inheritanceMetadata = (InheritanceMetadata)metadata.inheritance().orElseThrow()).parent().equals(metadata.type())) {
            CriteriaCondition condition = CriteriaCondition.eq((Element)Element.of((String)inheritanceMetadata.discriminatorColumn(), (Object)inheritanceMetadata.discriminatorValue()));
            if (query.condition().isPresent()) {
                CriteriaCondition columnCondition = (CriteriaCondition)query.condition().orElseThrow();
                condition = condition.and(columnCondition);
            }
            return new MappingQuery(query.sorts(), query.limit(), query.skip(), condition, query.name(), query.columns());
        }
        return query;
    }

    protected Long executeCountByQuery(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        return this.template().count(query);
    }

    protected boolean executeExistsByQuery(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        return this.template().exists(query);
    }

    protected Function<PageRequest, Page<T>> getPage(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        return p -> {
            Stream entities = this.template().select(query);
            return NoSQLPage.of(entities.toList(), (PageRequest)p);
        };
    }

    protected Function<PageRequest, Optional<T>> getSingleResult(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        return p -> this.template().singleResult(query);
    }

    protected Function<PageRequest, Stream<T>> streamPagination(org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        return p -> this.template().select(query);
    }

    protected org.eclipse.jnosql.communication.semistructured.SelectQuery updateQueryDynamically(Object[] args, org.eclipse.jnosql.communication.semistructured.SelectQuery query) {
        org.eclipse.jnosql.communication.semistructured.SelectQuery documentQuery = this.includeInheritance(query);
        SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])args, this.sortParser());
        if (special.isEmpty()) {
            return documentQuery;
        }
        Optional limit = special.limit();
        if (special.hasOnlySort()) {
            ArrayList sorts = new ArrayList();
            sorts.addAll(documentQuery.sorts());
            sorts.addAll(special.sorts());
            long skip = limit.map(l -> l.startAt() - 1L).orElse(documentQuery.skip());
            long max = limit.map(Limit::maxResults).orElse((int)documentQuery.limit()).intValue();
            return new MappingQuery(sorts, max, skip, documentQuery.condition().orElse(null), documentQuery.name(), documentQuery.columns());
        }
        if (limit.isPresent()) {
            long skip = limit.map(l -> l.startAt() - 1L).orElse(documentQuery.skip());
            long max = limit.map(Limit::maxResults).orElse((int)documentQuery.limit()).intValue();
            return new MappingQuery(documentQuery.sorts(), max, skip, documentQuery.condition().orElse(null), documentQuery.name(), documentQuery.columns());
        }
        return special.pageRequest().map(p -> {
            long size = p.size();
            long skip = NoSQLPage.skip((PageRequest)p);
            ArrayList sorts = documentQuery.sorts();
            if (!special.sorts().isEmpty()) {
                sorts = new ArrayList(documentQuery.sorts());
                sorts.addAll(special.sorts());
            }
            return new MappingQuery(sorts, size, skip, documentQuery.condition().orElse(null), documentQuery.name(), documentQuery.columns());
        }).orElse(documentQuery);
    }

    protected Function<String, String> sortParser() {
        return property -> this.parser().fireSortProperty(this.entityMetadata().name(), property);
    }
}

