/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.query.AbstractRepository;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.semistructured.SemiStructuredTemplate;
import org.eclipse.jnosql.mapping.semistructured.query.AbstractSemiStructuredRepository;
import org.eclipse.jnosql.mapping.semistructured.query.AbstractSemiStructuredRepositoryProxy;

public class SemiStructuredRepositoryProxy<T, K>
extends AbstractSemiStructuredRepositoryProxy<T, K> {
    private final SemiStructuredTemplate template;
    private final SemiStructuredRepository<T, K> repository;
    private final EntityMetadata entityMetadata;
    private final Converters converters;
    private final Class<?> repositoryType;

    public SemiStructuredRepositoryProxy(SemiStructuredTemplate template, EntitiesMetadata entities, Class<?> repositoryType, Converters converters) {
        this.template = template;
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.entityMetadata = entities.get(typeClass);
        this.repository = new SemiStructuredRepository(template, this.entityMetadata);
        this.converters = converters;
        this.repositoryType = repositoryType;
    }

    protected AbstractRepository<T, K> repository() {
        return this.repository;
    }

    @Override
    protected EntityMetadata entityMetadata() {
        return this.entityMetadata;
    }

    @Override
    protected SemiStructuredTemplate template() {
        return this.template;
    }

    @Override
    protected Converters converters() {
        return this.converters;
    }

    protected Class<?> repositoryType() {
        return this.repositoryType;
    }

    public static class SemiStructuredRepository<T, K>
    extends AbstractSemiStructuredRepository<T, K> {
        private final SemiStructuredTemplate template;
        private final EntityMetadata entityMetadata;

        SemiStructuredRepository(SemiStructuredTemplate template, EntityMetadata entityMetadata) {
            this.template = template;
            this.entityMetadata = entityMetadata;
        }

        @Override
        protected SemiStructuredTemplate template() {
            return this.template;
        }

        protected EntityMetadata entityMetadata() {
            return this.entityMetadata;
        }

        public static <T, K> SemiStructuredRepository<T, K> of(SemiStructuredTemplate template, EntityMetadata metadata) {
            Objects.requireNonNull(template, "template is required");
            Objects.requireNonNull(metadata, "metadata is required");
            return new SemiStructuredRepository<T, K>(template, metadata);
        }
    }
}

