/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.eclipse.jnosql.communication.semistructured.CriteriaCondition;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.util.ConverterUtil;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.semistructured.MappingQuery;

public enum SemiStructuredParameterBasedQuery {
    INSTANCE;

    private static final IntFunction<CriteriaCondition[]> TO_ARRAY;

    public SelectQuery toQuery(Map<String, Object> params, List<Sort<?>> sorts, EntityMetadata entityMetadata) {
        Converters convert = (Converters)CDI.current().select(Converters.class, new Annotation[0]).get();
        ArrayList<CriteriaCondition> conditions = new ArrayList<CriteriaCondition>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            conditions.add(this.condition(convert, entityMetadata, entry));
        }
        ArrayList updateSorter = new ArrayList();
        for (Sort<?> sort : sorts) {
            String name = entityMetadata.fieldMapping(sort.property()).map(FieldParameterMetadata::name).orElse(sort.property());
            updateSorter.add(sort.isAscending() ? Sort.asc((String)name) : Sort.desc((String)name));
        }
        CriteriaCondition criteriaCondition = this.condition(conditions);
        String string = entityMetadata.name();
        return new MappingQuery(updateSorter, 0L, 0L, criteriaCondition, string);
    }

    public SelectQuery toQueryNative(Map<String, Object> params, List<Sort<?>> sorts, PageRequest pageRequest, EntityMetadata entityMetadata) {
        ArrayList<CriteriaCondition> conditions = new ArrayList<CriteriaCondition>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            conditions.add(this.condition(entityMetadata, entry));
        }
        ArrayList updateSorter = new ArrayList();
        for (Sort<?> sort : sorts) {
            String name = entityMetadata.fieldMapping(sort.property()).map(FieldParameterMetadata::name).orElse(sort.property());
            updateSorter.add(sort.isAscending() ? Sort.asc((String)name) : Sort.desc((String)name));
        }
        CriteriaCondition criteriaCondition = this.condition(conditions);
        String string = entityMetadata.name();
        long limit = 0L;
        long skip = 0L;
        if (pageRequest != null) {
            limit = pageRequest.size();
            skip = NoSQLPage.skip((PageRequest)pageRequest);
        }
        return new MappingQuery(updateSorter, limit, skip, criteriaCondition, string);
    }

    private CriteriaCondition condition(List<CriteriaCondition> conditions) {
        if (conditions.isEmpty()) {
            return null;
        }
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        return CriteriaCondition.and((CriteriaCondition[])((CriteriaCondition[])conditions.toArray(TO_ARRAY)));
    }

    private CriteriaCondition condition(Converters convert, EntityMetadata entityMetadata, Map.Entry<String, Object> entry) {
        String name = entityMetadata.fieldMapping(entry.getKey()).map(FieldParameterMetadata::name).orElse(entry.getKey());
        Object value = ConverterUtil.getValue((Object)entry.getValue(), (EntityMetadata)entityMetadata, (String)entry.getKey(), (Converters)convert);
        return CriteriaCondition.eq((String)name, (Object)value);
    }

    private CriteriaCondition condition(EntityMetadata entityMetadata, Map.Entry<String, Object> entry) {
        String name = entityMetadata.fieldMapping(entry.getKey()).map(FieldParameterMetadata::name).orElse(entry.getKey());
        Object value = entry.getValue();
        return CriteriaCondition.eq((String)name, (Object)value);
    }

    static {
        TO_ARRAY = CriteriaCondition[]::new;
    }
}

