/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured.query;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import jakarta.data.repository.Find;
import jakarta.data.repository.OrderBy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.mapping.core.repository.DynamicQueryMethodReturn;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.RepositoryReflectionUtils;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.semistructured.query.BaseSemiStructuredRepository;
import org.eclipse.jnosql.mapping.semistructured.query.SemiStructuredParameterBasedQuery;

public abstract class AbstractSemiStructuredRepositoryProxy<T, K>
extends BaseSemiStructuredRepository<T, K> {
    protected Object executeQuery(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        String entity = this.entityMetadata().name();
        DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(params).withMethod(method).withTypeClass(type).withPrepareConverter(q -> this.template().prepare((String)q, entity)).build();
        return methodReturn.execute();
    }

    protected Object executeCursorPagination(Object instance, Method method, Object[] params) {
        if (method.getAnnotation(Find.class) == null) {
            SelectQuery query = this.query(method, params);
            SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])params);
            PageRequest pageRequest = (PageRequest)special.pageRequest().orElseThrow(() -> new IllegalArgumentException("Pageable is required in the method signature as parameter at " + method));
            return this.template().selectCursor(query, pageRequest);
        }
        Map parameters = RepositoryReflectionUtils.INSTANCE.getBy(method, params);
        SelectQuery query = SemiStructuredParameterBasedQuery.INSTANCE.toQuery(parameters, AbstractSemiStructuredRepositoryProxy.getSorts(method), this.entityMetadata());
        SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])params);
        PageRequest pageRequest = (PageRequest)special.pageRequest().orElseThrow(() -> new IllegalArgumentException("Pageable is required in the method signature as parameter at " + method));
        return this.template().selectCursor(query, pageRequest);
    }

    protected Object executeDeleteByAll(Object instance, Method method, Object[] params) {
        DeleteQuery deleteQuery = this.deleteQuery(method, params);
        this.template().delete(deleteQuery);
        return Void.class;
    }

    protected Object executeFindAll(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        SelectQuery query = SelectQuery.select().from(this.entityMetadata().name()).build();
        return this.executeFindByQuery(method, params, type, this.updateQueryDynamically(params, query));
    }

    protected Object executeExistByQuery(Object instance, Method method, Object[] params) {
        return this.executeExistsByQuery(this.query(method, params));
    }

    protected Object executeCountByQuery(Object instance, Method method, Object[] params) {
        return this.executeCountByQuery(this.query(method, params));
    }

    protected Object executeFindByQuery(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        return this.executeFindByQuery(method, params, type, this.query(method, params));
    }

    protected Object executeParameterBased(Object instance, Method method, Object[] params) {
        Class type = this.entityMetadata().type();
        Map parameters = RepositoryReflectionUtils.INSTANCE.getBy(method, params);
        SelectQuery query = SemiStructuredParameterBasedQuery.INSTANCE.toQuery(parameters, AbstractSemiStructuredRepositoryProxy.getSorts(method), this.entityMetadata());
        return this.executeFindByQuery(method, params, type, this.updateQueryDynamically(params, query));
    }

    private static List<Sort<?>> getSorts(Method method) {
        ArrayList sorts = new ArrayList();
        OrderBy[] orders = (OrderBy[])method.getAnnotationsByType(OrderBy.class);
        Stream.of(orders).map(o -> o.descending() ? Sort.desc((String)o.value()) : Sort.asc((String)o.value())).forEach(sorts::add);
        return sorts;
    }
}

