/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.nosql.AttributeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element element, FieldMetadata field, EntityConverter converter) {
            Object subEntity = converter.toEntity(field.type(), elements);
            EntityMetadata mapping = converter.entities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.fields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element subElement, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(subElement)) {
                this.converterSubDocument(instance, subElement, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.type(), elements));
            }
        }

        private <T> void converterSubDocument(T instance, Element subElement, FieldMetadata field, EntityConverter converter) {
            Object value = subElement.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Element> embeddedColumns = new ArrayList<Element>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedColumns.add(Element.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.type(), embeddedColumns));
            } else {
                field.write(instance, converter.toEntity(field.type(), (List)subElement.get((TypeSupplier)new TypeReference<List<Element>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> columns, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                GenericFieldMetadata genericField = (GenericFieldMetadata)field;
                Collection elements = genericField.collectionInstance();
                List embeddable = (List)element.get();
                if (Objects.isNull(embeddable)) {
                    return;
                }
                for (List elementList : embeddable) {
                    Object item = converter.toEntity(genericField.elementType(), elementList);
                    elements.add(item);
                }
                field.write(instance, (Object)elements);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Element> elements, Element element, FieldMetadata field, EntityConverter converter) {
            if (Objects.nonNull(element)) {
                Value value = element.value();
                Optional optionalConverter = field.converter();
                if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.converters().get((FieldParameterMetadata)field);
                    Object attr = value.isInstanceOf(List.class) ? element : value.get();
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(attr);
                    field.write(instance, field.value(Value.of((Object)attributeConverted)));
                } else {
                    field.write(instance, field.value(value));
                }
            }
        }
    };


    static FieldConverter get(FieldMetadata field) {
        if (MappingType.EMBEDDED.equals((Object)field.mappingType())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.mappingType()) || MappingType.EMBEDDED_GROUP.equals((Object)field.mappingType())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMetadata field) {
        return MappingType.COLLECTION.equals((Object)field.mappingType()) && ((GenericFieldMetadata)field).isEmbeddable();
    }

    abstract <X, Y, T> void convert(T var1, List<Element> var2, Element var3, FieldMetadata var4, EntityConverter var5);

    <X, Y, T> void convert(T instance, Element element, FieldMetadata field, EntityConverter converter) {
        this.convert(instance, null, element, field, converter);
    }
}

