/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.semistructured;

import jakarta.data.exceptions.MappingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jnosql.communication.Entry;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.Element;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.eclipse.jnosql.mapping.semistructured.AttributeFieldValue;
import org.eclipse.jnosql.mapping.semistructured.DefaultAttributeFieldValue;
import org.eclipse.jnosql.mapping.semistructured.FieldConverter;
import org.eclipse.jnosql.mapping.semistructured.ParameterConverter;

public abstract class EntityConverter {
    protected abstract EntitiesMetadata entities();

    protected abstract Converters converters();

    public CommunicationEntity toCommunication(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.entities().get(entity.getClass());
        CommunicationEntity communication = CommunicationEntity.of((String)mapping.name());
        mapping.fields().stream().map(f -> this.to((FieldMetadata)f, entity)).map(f -> f.toElements(this, this.converters())).flatMap(Collection::stream).forEach(arg_0 -> ((CommunicationEntity)communication).add(arg_0));
        mapping.inheritance().ifPresent(i -> communication.add(i.discriminatorColumn(), (Object)i.discriminatorValue()));
        return communication;
    }

    public <T> T toEntity(Class<T> type, CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        return this.toEntity(type, entity.elements());
    }

    public <T> T toEntity(T type, CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        if (type.getClass().isRecord()) {
            return (T)this.toEntity(type.getClass(), entity.elements());
        }
        EntityMetadata mapping = this.entities().get(type.getClass());
        return this.convertEntity(entity.elements(), mapping, type);
    }

    public <T> T toEntity(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.entities().findByName(entity.name());
        if (mapping.isInheritance()) {
            return this.mapInheritanceEntity(entity, mapping.type());
        }
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.elements(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.elements(), mapping);
    }

    protected AttributeFieldValue to(FieldMetadata field, Object entity) {
        Object value = field.read(entity);
        return DefaultAttributeFieldValue.of(value, field);
    }

    protected <T> Consumer<String> feedObject(T entity, List<Element> elements, Map<String, FieldMetadata> fieldsGroupByName) {
        return k -> {
            Optional<Element> element = elements.stream().filter(c -> c.name().equals(k)).filter(e -> !e.value().isNull()).findFirst();
            FieldMetadata field = (FieldMetadata)fieldsGroupByName.get(k);
            FieldConverter fieldConverter = FieldConverter.get(field);
            if (MappingType.ENTITY.equals((Object)field.mappingType())) {
                element.ifPresent(c -> fieldConverter.convert(entity, (Element)c, field, this));
            } else {
                fieldConverter.convert(entity, elements, element.orElse(null), field, this);
            }
        };
    }

    protected <T> T toEntity(Class<T> type, List<Element> elements) {
        EntityMetadata mapping = this.entities().get(type);
        if (mapping.isInheritance()) {
            return this.inheritanceToEntity(elements, mapping);
        }
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(elements, mapping, instance);
        }
        return this.convertEntityByConstructor(elements, mapping);
    }

    private <T> T convertEntityByConstructor(List<Element> elements, EntityMetadata mapping) {
        ConstructorBuilder builder = ConstructorBuilder.of((ConstructorMetadata)mapping.constructor());
        for (ParameterMetaData parameter : builder.parameters()) {
            Optional<Element> element = elements.stream().filter(c -> c.name().equals(parameter.name())).findFirst();
            element.ifPresentOrElse(c -> {
                ParameterConverter converter = ParameterConverter.of(parameter, this.entities());
                converter.convert(this, (Element)c, parameter, builder);
            }, () -> ((ConstructorBuilder)builder).addEmptyParameter());
        }
        return (T)builder.build();
    }

    private <T> T convertEntity(List<Element> elements, EntityMetadata mapping, T instance) {
        Map fieldsGroupByName = mapping.fieldsGroupByName();
        List<String> names = elements.stream().map(Entry::name).sorted().toList();
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            MappingType type = ((FieldMetadata)fieldsGroupByName.get(k)).mappingType();
            return MappingType.EMBEDDED.equals((Object)type) || MappingType.EMBEDDED_GROUP.equals((Object)type) || MappingType.ENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, elements, fieldsGroupByName));
        return instance;
    }

    private <T> T mapInheritanceEntity(CommunicationEntity entity, Class<?> type) {
        Map group = this.entities().findByParentGroupByDiscriminatorValue(type);
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + entity.name());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::discriminatorColumn).orElseThrow();
        String discriminator = (String)entity.find(column, String.class).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata mapping = this.entities().get(inheritance.entity());
        ConstructorMetadata constructor = mapping.constructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.elements(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.elements(), mapping);
    }

    private <T> T inheritanceToEntity(List<Element> elements, EntityMetadata mapping) {
        Map group = this.entities().findByParentGroupByDiscriminatorValue(mapping.type());
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the structure " + mapping.name());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::discriminatorColumn).orElseThrow();
        String discriminator = elements.stream().filter(d -> d.name().equals(column)).findFirst().map(d -> (String)d.get(String.class)).orElseThrow(() -> new MappingException("To inheritance there is the discriminator element missing at the structure, the field's name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata inheritanceMetadata = this.entities().get(inheritance.entity());
        Object instance = inheritanceMetadata.newInstance();
        return (T)this.convertEntity(elements, inheritanceMetadata, instance);
    }
}

