/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.Column;
import jakarta.nosql.Convert;
import jakarta.nosql.Id;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.DefaultArrayParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.DefaultCollectionParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.DefaultMapParameterMetaData;
import org.eclipse.jnosql.mapping.reflection.DefaultParameterMetaData;

class ParameterMetaDataBuilder {
    private final Parameter parameter;

    private ParameterMetaDataBuilder(Parameter parameter) {
        this.parameter = parameter;
    }

    ParameterMetaData build() {
        Id id = this.parameter.getAnnotation(Id.class);
        Column column = this.parameter.getAnnotation(Column.class);
        Convert convert = this.parameter.getAnnotation(Convert.class);
        Class<?> type = this.parameter.getType();
        String name = Optional.ofNullable(id).map(Id::value).or(() -> Optional.ofNullable(column).map(Column::value)).orElse(null);
        if ((Objects.isNull(name) || name.isBlank()) && this.parameter.getDeclaringExecutable().getDeclaringClass().isRecord()) {
            name = this.parameter.getName();
        }
        MappingType mappingType = MappingType.of(this.parameter.getType());
        return switch (mappingType) {
            case MappingType.COLLECTION -> new DefaultCollectionParameterMetaData(name, type, id != null, Optional.ofNullable(convert).map(Convert::value).orElse(null), mappingType, this.parameter::getParameterizedType);
            case MappingType.ARRAY -> new DefaultArrayParameterMetaData(name, type, id != null, Optional.ofNullable(convert).map(Convert::value).orElse(null), mappingType, this.parameter.getType().getComponentType());
            case MappingType.MAP -> new DefaultMapParameterMetaData(name, type, id != null, Optional.ofNullable(convert).map(Convert::value).orElse(null), mappingType, this.parameter::getParameterizedType);
            default -> new DefaultParameterMetaData(name, type, id != null, Optional.ofNullable(convert).map(Convert::value).orElse(null), mappingType);
        };
    }

    public static ParameterMetaData of(Parameter parameter) {
        ParameterMetaDataBuilder builder = new ParameterMetaDataBuilder(parameter);
        return builder.build();
    }
}

