/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.metadata.MapFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.AbstractFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;

final class DefaultMapFieldMetadata
extends AbstractFieldMetadata
implements MapFieldMetadata {
    private final TypeSupplier<?> typeSupplier;
    private final Class<?> keyType;
    private final Class<?> valueType;

    DefaultMapFieldMetadata(MappingType type, Field field, String name, TypeSupplier<?> typeSupplier, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer, String udt) {
        super(type, field, name, converter, reader, writer, udt);
        this.typeSupplier = typeSupplier;
        this.keyType = (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
        this.valueType = (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[1];
    }

    @Override
    public Object value(Value value) {
        return value.get(this.typeSupplier);
    }

    public boolean isId() {
        return false;
    }

    public boolean isEmbeddable() {
        return false;
    }

    public Class<?> keyType() {
        return this.keyType;
    }

    public Class<?> valueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMapFieldMetadata that = (DefaultMapFieldMetadata)o;
        return Objects.equals(this.typeSupplier, that.typeSupplier) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.typeSupplier, this.keyType, this.valueType);
    }
}

