/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import java.lang.reflect.Array;
import java.util.Collection;
import org.eclipse.jnosql.mapping.metadata.ArrayParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.DefaultParameterMetaData;

class DefaultArrayParameterMetaData
extends DefaultParameterMetaData
implements ArrayParameterMetaData {
    private final Class<?> elementType;

    DefaultArrayParameterMetaData(String name, Class<?> type, boolean id, Class<? extends AttributeConverter<?, ?>> converter, MappingType mappingType, Class<?> elementType) {
        super(name, type, id, converter, mappingType);
        this.elementType = elementType;
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public Object arrayInstance(Collection<?> collection) {
        Object array = Array.newInstance(this.elementType, collection.size());
        int index = 0;
        for (Object item : collection) {
            Array.set(array, index++, item);
        }
        return array;
    }
}

