/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection.spi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.mapping.metadata.ClassConverter;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.GroupEntityMetadata;

public class ReflectionEntityMetadataExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(ReflectionEntityMetadataExtension.class.getName());
    private static final Map<Class<?>, EntityMetadata> ENTITY_METADATA_BY_CLASS = new ConcurrentHashMap();
    private static final Map<String, EntityMetadata> ENTITY_METADATA_BY_ENTITY_NAME = new ConcurrentHashMap<String, EntityMetadata>();

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager bm) {
        this.scanEntitiesAndEmbeddableEntities();
        event.addBean().read(bm.createAnnotatedType(CDIGroupEntityMetadata.class)).beanClass(CDIGroupEntityMetadata.class).alternative(true).priority(2000).scope(ApplicationScoped.class);
    }

    private void scanEntitiesAndEmbeddableEntities() {
        LOGGER.fine("Starting the scanning process for Entity and Embeddable annotations: ");
        ClassConverter converter = ClassConverter.load();
        ClassScanner scanner = ClassScanner.load();
        scanner.entities().forEach(entity -> {
            EntityMetadata entityMetadata = (EntityMetadata)converter.apply(entity);
            if (entityMetadata.hasEntityName()) {
                ENTITY_METADATA_BY_ENTITY_NAME.put(entityMetadata.name(), entityMetadata);
            }
            ENTITY_METADATA_BY_CLASS.put((Class<?>)entity, entityMetadata);
        });
        scanner.embeddables().forEach(embeddable -> {
            EntityMetadata entityMetadata = (EntityMetadata)converter.apply(embeddable);
            ENTITY_METADATA_BY_CLASS.put((Class<?>)embeddable, entityMetadata);
        });
        Optional.ofNullable(LOGGER).filter(l -> l.isLoggable(Level.FINEST)).ifPresent(l -> l.fine("Finishing the scanning with: %d Entity and Embeddable scanned classes and %s Named entities".formatted(ENTITY_METADATA_BY_CLASS.size(), ENTITY_METADATA_BY_ENTITY_NAME.size())));
    }

    public static class CDIGroupEntityMetadata
    implements GroupEntityMetadata {
        public Map<String, EntityMetadata> mappings() {
            return ENTITY_METADATA_BY_ENTITY_NAME;
        }

        public Map<Class<?>, EntityMetadata> classes() {
            return ENTITY_METADATA_BY_CLASS;
        }
    }
}

