/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.data.repository.Repository;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

enum RepositoryFilter implements Predicate<Class<?>>
{
    INSTANCE;

    private static final String PROVIDER = "Eclipse_JNoSQL";

    @Override
    public boolean test(Class<?> type) {
        return this.isSupported(type) && this.isValid(type);
    }

    public boolean isSupported(Class<?> type) {
        Optional<String> provider = this.getProvider(type);
        return provider.map(p -> "".equals(p) || PROVIDER.equalsIgnoreCase((String)p)).isPresent();
    }

    public boolean isValid(Class<?> type) {
        Optional<Class<?>> entity = this.getEntity(type);
        return entity.map(c -> c.getAnnotation(Entity.class)).isPresent();
    }

    private Optional<String> getProvider(Class<?> repository) {
        Annotation[] annos = repository.getAnnotations();
        return Stream.of(annos).filter(Repository.class::isInstance).map(a -> ((Repository)a).provider()).findAny();
    }

    private Optional<Class<?>> getEntity(Class<?> repository) {
        Type[] interfaces = repository.getGenericInterfaces();
        if (interfaces.length == 0) {
            return Optional.empty();
        }
        ParameterizedType param = (ParameterizedType)interfaces[0];
        Type[] arguments = param.getActualTypeArguments();
        if (arguments.length == 0) {
            return Optional.empty();
        }
        Type argument = arguments[0];
        if (argument instanceof Class) {
            Class entity = (Class)argument;
            return Optional.of(entity);
        }
        return Optional.empty();
    }
}

