/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import java.lang.reflect.Field;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.mapping.metadata.ArrayFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.CollectionFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MapFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.DefaultArrayFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.DefaultCollectionFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.DefaultFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.DefaultMapFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.EmbeddedFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;

class FieldMappingBuilder {
    private MappingType type;
    private Field field;
    private String name;
    private String entityName;
    private TypeSupplier<?> typeSupplier;
    private Class<? extends AttributeConverter<?, ?>> converter;
    private boolean id;
    private FieldReader reader;
    private FieldWriter writer;
    private String udt;
    private Class<?> elementType;

    FieldMappingBuilder() {
    }

    public FieldMappingBuilder type(MappingType type) {
        this.type = type;
        return this;
    }

    public FieldMappingBuilder field(Field field) {
        this.field = field;
        return this;
    }

    public FieldMappingBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FieldMappingBuilder typeSupplier(TypeSupplier<?> typeSupplier) {
        this.typeSupplier = typeSupplier;
        return this;
    }

    public FieldMappingBuilder entityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public FieldMappingBuilder converter(Class<? extends AttributeConverter<?, ?>> converter) {
        this.converter = converter;
        return this;
    }

    public FieldMappingBuilder id(boolean id) {
        this.id = id;
        return this;
    }

    public FieldMappingBuilder writer(FieldWriter writer) {
        this.writer = writer;
        return this;
    }

    public FieldMappingBuilder udt(String udt) {
        this.udt = udt;
        return this;
    }

    public FieldMappingBuilder reader(FieldReader reader) {
        this.reader = reader;
        return this;
    }

    public FieldMappingBuilder elementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public DefaultFieldMetadata buildDefault() {
        return new DefaultFieldMetadata(this.type, this.field, this.name, this.converter, this.id, this.reader, this.writer, this.udt);
    }

    public CollectionFieldMetadata buildCollection() {
        return new DefaultCollectionFieldMetadata(this.type, this.field, this.name, this.typeSupplier, this.converter, this.reader, this.writer, this.udt);
    }

    public MapFieldMetadata buildMap() {
        return new DefaultMapFieldMetadata(this.type, this.field, this.name, this.typeSupplier, this.converter, this.reader, this.writer, this.udt);
    }

    public EmbeddedFieldMetadata buildEmbedded() {
        return new EmbeddedFieldMetadata(this.type, this.field, this.name, this.entityName, this.reader, this.writer, this.udt);
    }

    public ArrayFieldMetadata buildArray() {
        return new DefaultArrayFieldMetadata(this.type, this.field, this.name, this.elementType, this.converter, this.reader, this.writer, this.udt);
    }
}

