/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.metadata.ClassConverter;
import org.eclipse.jnosql.mapping.metadata.ClassInformationNotFoundException;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.GroupEntityMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.ReflectionClassConverter;

@ApplicationScoped
class DefaultEntitiesMetadata
implements EntitiesMetadata {
    private final Map<String, EntityMetadata> mappings = new ConcurrentHashMap<String, EntityMetadata>();
    private final Map<Class<?>, EntityMetadata> classes = new ConcurrentHashMap();
    private final Map<String, EntityMetadata> findBySimpleName = new ConcurrentHashMap<String, EntityMetadata>();
    private final Map<String, EntityMetadata> findByClassName = new ConcurrentHashMap<String, EntityMetadata>();
    private final ClassConverter converter = new ReflectionClassConverter();
    @Inject
    private GroupEntityMetadata extension;

    @PostConstruct
    public void init() {
        this.classes.putAll(this.extension.classes());
        this.classes.values().forEach(r -> this.findByClassName.put(r.className(), (EntityMetadata)r));
        this.extension.mappings().forEach((k, v) -> this.mappings.put(k.toUpperCase(Locale.US), (EntityMetadata)v));
        this.mappings.values().forEach(r -> {
            this.findBySimpleName.put(r.simpleName(), (EntityMetadata)r);
            this.findByClassName.put(r.className(), (EntityMetadata)r);
        });
    }

    EntityMetadata load(Class<?> type) {
        EntityMetadata metadata = (EntityMetadata)this.converter.apply(type);
        if (metadata.hasEntityName()) {
            this.mappings.put(type.getName().toUpperCase(Locale.US), metadata);
        }
        this.findBySimpleName.put(type.getSimpleName(), metadata);
        this.findByClassName.put(type.getName(), metadata);
        return metadata;
    }

    public EntityMetadata get(Class<?> entity) {
        return this.classes.computeIfAbsent(entity, this::load);
    }

    public Map<String, InheritanceMetadata> findByParentGroupByDiscriminatorValue(Class<?> parent) {
        Objects.requireNonNull(parent, "parent is required");
        return this.classes.values().stream().flatMap(c -> c.inheritance().stream()).filter(p -> p.isParent(parent)).collect(Collectors.toMap(InheritanceMetadata::discriminatorValue, Function.identity()));
    }

    public EntityMetadata findByName(String name) {
        Objects.requireNonNull(name, "name is required");
        return Optional.ofNullable(this.mappings.get(name.toUpperCase(Locale.US))).orElseThrow(() -> new ClassInformationNotFoundException("There is not entity found with the name: " + name));
    }

    public Optional<EntityMetadata> findBySimpleName(String name) {
        Objects.requireNonNull(name, "name is required");
        return Optional.ofNullable(this.findBySimpleName.get(name));
    }

    public Optional<EntityMetadata> findByClassName(String name) {
        Objects.requireNonNull(name, "name is required");
        return Optional.ofNullable(this.findByClassName.get(name));
    }

    public String toString() {
        return "DefaultEntitiesMetadata{mappings-size=" + this.mappings.size() + ", classes=" + this.classes + ", classConverter=" + this.converter + ", extension=" + this.extension + "}";
    }
}

