/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.metadata.CollectionFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.CollectionSupplier;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.AbstractFieldMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldReader;
import org.eclipse.jnosql.mapping.reflection.FieldWriter;
import org.eclipse.jnosql.mapping.reflection.Reflections;

final class DefaultCollectionFieldMetadata
extends AbstractFieldMetadata
implements CollectionFieldMetadata {
    private static final List<CollectionSupplier> COLLECTION_SUPPLIERS = ServiceLoader.load(CollectionSupplier.class).stream().map(ServiceLoader.Provider::get).toList();
    private final TypeSupplier<?> typeSupplier;
    private final boolean entityField;
    private final boolean embeddableField;

    DefaultCollectionFieldMetadata(MappingType type, Field field, String name, TypeSupplier<?> typeSupplier, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer, String udt) {
        super(type, field, name, converter, reader, writer, udt);
        this.typeSupplier = typeSupplier;
        this.entityField = this.hasFieldAnnotation(Entity.class);
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class);
    }

    @Override
    public Object value(Value value) {
        if (value.get() instanceof Iterable) {
            return value.get(this.typeSupplier);
        }
        return Value.of(Collections.singletonList(value.get())).get(this.typeSupplier);
    }

    public boolean isId() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCollectionFieldMetadata that = (DefaultCollectionFieldMetadata)o;
        return this.mappingType == that.mappingType && Objects.equals(this.field, that.field) && Objects.equals(this.typeSupplier, that.typeSupplier) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.mappingType, this.field, this.name, this.typeSupplier);
    }

    public boolean isEmbeddable() {
        return this.isEmbeddableField() || this.isEntityField();
    }

    private boolean isEntityField() {
        return this.entityField;
    }

    private boolean isEmbeddableField() {
        return this.embeddableField;
    }

    private boolean hasFieldAnnotation(Class<?> annotation) {
        ParameterizedType collectionType = Reflections.findParameterizedType(this.field.getGenericType(), Collection.class).orElseThrow(() -> new IllegalStateException(MessageFormat.format("Unable to find parameterized Collection implementation for {0}", this.field)));
        return ((Class)collectionType.getActualTypeArguments()[0]).getAnnotation(annotation) != null;
    }

    public Class<?> elementType() {
        return (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
    }

    public Collection<?> collectionInstance() {
        Class<?> type = this.type();
        CollectionSupplier supplier = COLLECTION_SUPPLIERS.stream().filter(c -> c.test((Object)type)).findFirst().orElseThrow(() -> new UnsupportedOperationException("This collection is not supported yet: " + type));
        return (Collection)supplier.get();
    }

    public String toString() {
        return "DefaultCollectionFieldMetadata{typeSupplier=" + this.typeSupplier + ", type=" + this.mappingType + ", field=" + this.field + ", name='" + this.name + "', fieldName='" + this.fieldName + "', converter=" + this.converter + "}";
    }
}

