/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.Entity;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;

enum RepositoryFilter implements Predicate<Class<?>>
{
    INSTANCE;


    @Override
    public boolean test(Class<?> type) {
        Optional<Class<?>> entity = this.getEntity(type);
        return entity.map(c -> c.getAnnotation(Entity.class)).isPresent();
    }

    public boolean isInvalid(Class<?> type) {
        Optional<Class<?>> entity = this.getEntity(type);
        return entity.map(c -> c.getAnnotation(Entity.class)).isEmpty();
    }

    private Optional<Class<?>> getEntity(Class<?> repository) {
        Type[] interfaces = repository.getGenericInterfaces();
        if (interfaces.length == 0) {
            return Optional.empty();
        }
        ParameterizedType param = (ParameterizedType)interfaces[0];
        Type[] arguments = param.getActualTypeArguments();
        if (arguments.length == 0) {
            return Optional.empty();
        }
        Type argument = arguments[0];
        if (argument instanceof Class) {
            Class entity = (Class)argument;
            return Optional.of(entity);
        }
        return Optional.empty();
    }
}

