/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import jakarta.nosql.Convert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.metadata.ClassConverter;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.reflection.ConstructorMetadataBuilder;
import org.eclipse.jnosql.mapping.reflection.DefaultEntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMappingBuilder;
import org.eclipse.jnosql.mapping.reflection.InstanceSupplier;
import org.eclipse.jnosql.mapping.reflection.NativeMapping;
import org.eclipse.jnosql.mapping.reflection.Reflections;

public final class ReflectionClassConverter
implements ClassConverter {
    private static final Logger LOGGER = Logger.getLogger(ReflectionClassConverter.class.getName());
    private final Reflections reflections = new Reflections();
    private final ConstructorMetadataBuilder constructorMetadataBuilder = new ConstructorMetadataBuilder(this.reflections);

    public EntityMetadata apply(Class<?> entity) {
        long start = System.currentTimeMillis();
        String entityName = this.reflections.getEntityName(entity);
        List<FieldMetadata> fields = this.reflections.getFields(entity).stream().map(this::to).collect(Collectors.toList());
        List<String> fieldsName = fields.stream().map(FieldParameterMetadata::name).collect(Collectors.toList());
        Map<String, NativeMapping> nativeFieldGroupByJavaField = this.getNativeFieldGroupByJavaField(fields, "", "");
        Map fieldsGroupedByName = fields.stream().collect(Collectors.collectingAndThen(Collectors.toMap(FieldParameterMetadata::name, Function.identity()), Collections::unmodifiableMap));
        Constructor<?> constructor = Reflections.getConstructor(entity);
        InstanceSupplier instanceSupplier = () -> Reflections.newInstance(constructor);
        InheritanceMetadata inheritance = this.reflections.getInheritance(entity).orElse(null);
        boolean hasInheritanceAnnotation = this.reflections.hasInheritanceAnnotation(entity);
        EntityMetadata mapping = DefaultEntityMetadata.builder().name(entityName).type(entity).fields(fields).fieldsName(fieldsName).instanceSupplier(instanceSupplier).javaFieldGroupedByColumn(nativeFieldGroupByJavaField).fieldsGroupedByName(fieldsGroupedByName).inheritance(inheritance).hasInheritanceAnnotation(hasInheritanceAnnotation).constructor(this.constructorMetadataBuilder.build(entity)).build();
        long end = System.currentTimeMillis() - start;
        LOGGER.finest(String.format("Scanned the entity %s loaded with time of %d ms", entity.getName(), end));
        return mapping;
    }

    private Map<String, NativeMapping> getNativeFieldGroupByJavaField(List<FieldMetadata> fields, String javaField, String nativeField) {
        HashMap<String, NativeMapping> nativeFieldGroupByJavaField = new HashMap<String, NativeMapping>();
        for (FieldMetadata field : fields) {
            this.appendValue(nativeFieldGroupByJavaField, field, javaField, nativeField);
        }
        return nativeFieldGroupByJavaField;
    }

    private void appendValue(Map<String, NativeMapping> nativeFieldGroupByJavaField, FieldMetadata field, String javaField, String nativeField) {
        switch (field.mappingType()) {
            case ENTITY: {
                this.appendFields(nativeFieldGroupByJavaField, field, javaField, this.appendPreparePrefix(nativeField, field.name()));
                break;
            }
            case EMBEDDED: {
                this.appendFields(nativeFieldGroupByJavaField, field, javaField, nativeField);
                break;
            }
            case COLLECTION: {
                if (((GenericFieldMetadata)field).isEmbeddable()) {
                    Class type = ((GenericFieldMetadata)field).elementType();
                    String nativeFieldAppended = this.appendPreparePrefix(nativeField, field.name());
                    this.appendFields(nativeFieldGroupByJavaField, field, javaField, nativeFieldAppended, type);
                    return;
                }
                this.appendDefaultField(nativeFieldGroupByJavaField, field, javaField, nativeField);
                break;
            }
            default: {
                this.appendDefaultField(nativeFieldGroupByJavaField, field, javaField, nativeField);
            }
        }
    }

    private void appendDefaultField(Map<String, NativeMapping> nativeFieldGroupByJavaField, FieldMetadata field, String javaField, String nativeField) {
        nativeFieldGroupByJavaField.put(javaField.concat(field.fieldName()), NativeMapping.of(nativeField.concat(field.name()), field));
    }

    private void appendFields(Map<String, NativeMapping> nativeFieldGroupByJavaField, FieldMetadata field, String javaField, String nativeField) {
        Class type = field.type();
        this.appendFields(nativeFieldGroupByJavaField, field, javaField, nativeField, type);
    }

    private void appendFields(Map<String, NativeMapping> nativeFieldGroupByJavaField, FieldMetadata field, String javaField, String nativeField, Class<?> type) {
        Map<String, NativeMapping> entityMap = this.getNativeFieldGroupByJavaField(this.reflections.getFields(type).stream().map(this::to).collect(Collectors.toList()), this.appendPreparePrefix(javaField, field.fieldName()), nativeField);
        String nativeElement = entityMap.values().stream().map(NativeMapping::nativeField).collect(Collectors.joining(","));
        nativeFieldGroupByJavaField.put(this.appendPrefix(javaField, field.fieldName()), NativeMapping.of(nativeElement, field));
        nativeFieldGroupByJavaField.putAll(entityMap);
    }

    private String appendPreparePrefix(String prefix, String field) {
        return this.appendPrefix(prefix, field).concat(".");
    }

    private String appendPrefix(String prefix, String field) {
        if (prefix.isEmpty()) {
            return field;
        }
        return prefix.concat(field);
    }

    private FieldMetadata to(Field field) {
        MappingType mappingType = MappingType.of(field.getType());
        this.reflections.makeAccessible(field);
        Convert convert = field.getAnnotation(Convert.class);
        boolean id = this.reflections.isIdField(field);
        String columnName = id ? this.reflections.getIdName(field) : this.reflections.getColumnName(field);
        String udt = this.reflections.getUDTName(field);
        FieldMappingBuilder builder = new FieldMappingBuilder().name(columnName).field(field).type(mappingType).id(id).udt(udt).reader(bean -> this.reflections.getValue(bean, field)).writer((bean, value) -> this.reflections.setValue(bean, field, value));
        if (Objects.nonNull(convert)) {
            builder.converter(convert.value());
        }
        switch (mappingType) {
            case COLLECTION: 
            case MAP: {
                builder.typeSupplier(field::getGenericType);
                return builder.buildGeneric();
            }
            case EMBEDDED: {
                return builder.entityName(this.reflections.getEntityName(field.getType())).buildEmbedded();
            }
        }
        return builder.buildDefault();
    }
}

