/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.DefaultEntityMetadata;
import org.eclipse.jnosql.mapping.reflection.InstanceSupplier;
import org.eclipse.jnosql.mapping.reflection.NativeMapping;

class EntityMetadataBuilder {
    private String name;
    private List<String> fieldsName = Collections.emptyList();
    private Class<?> type;
    private List<FieldMetadata> fields = Collections.emptyList();
    private Map<String, NativeMapping> javaFieldGroupedByColumn = Collections.emptyMap();
    private Map<String, FieldMetadata> fieldsGroupedByName = Collections.emptyMap();
    private InstanceSupplier instanceSupplier;
    private InheritanceMetadata inheritance;
    private boolean hasInheritanceAnnotation;
    private ConstructorMetadata constructor;

    EntityMetadataBuilder() {
    }

    public EntityMetadataBuilder name(String name) {
        this.name = name;
        return this;
    }

    public EntityMetadataBuilder fieldsName(List<String> fieldsName) {
        this.fieldsName = fieldsName;
        return this;
    }

    public EntityMetadataBuilder type(Class<?> type) {
        this.type = type;
        return this;
    }

    public EntityMetadataBuilder fields(List<FieldMetadata> fields) {
        this.fields = fields;
        return this;
    }

    public EntityMetadataBuilder javaFieldGroupedByColumn(Map<String, NativeMapping> javaFieldGroupedByColumn) {
        this.javaFieldGroupedByColumn = javaFieldGroupedByColumn;
        return this;
    }

    public EntityMetadataBuilder fieldsGroupedByName(Map<String, FieldMetadata> fieldsGroupedByName) {
        this.fieldsGroupedByName = fieldsGroupedByName;
        return this;
    }

    public EntityMetadataBuilder instanceSupplier(InstanceSupplier instanceSupplier) {
        this.instanceSupplier = instanceSupplier;
        return this;
    }

    public EntityMetadataBuilder inheritance(InheritanceMetadata inheritance) {
        this.inheritance = inheritance;
        return this;
    }

    public EntityMetadataBuilder hasInheritanceAnnotation(boolean hasInheritanceAnnotation) {
        this.hasInheritanceAnnotation = hasInheritanceAnnotation;
        return this;
    }

    public EntityMetadataBuilder constructor(ConstructorMetadata constructor) {
        this.constructor = constructor;
        return this;
    }

    public EntityMetadata build() {
        return new DefaultEntityMetadata(this.name, this.fieldsName, this.type, this.fields, this.javaFieldGroupedByColumn, this.fieldsGroupedByName, this.instanceSupplier, this.inheritance, this.constructor, this.hasInheritanceAnnotation);
    }
}

