/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.reflection;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.mapping.metadata.ConstructorMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadataBuilder;
import org.eclipse.jnosql.mapping.reflection.InstanceSupplier;
import org.eclipse.jnosql.mapping.reflection.NativeMapping;

class DefaultEntityMetadata
implements EntityMetadata {
    private final String name;
    private final String simpleName;
    private final String className;
    private final List<String> fieldsName;
    private final Class<?> type;
    private final List<FieldMetadata> fields;
    private final InstanceSupplier instanceSupplier;
    private final Map<String, NativeMapping> javaFieldGroupedByColumn;
    private final Map<String, FieldMetadata> fieldsGroupedByName;
    private final FieldMetadata id;
    private final InheritanceMetadata inheritance;
    private final boolean hasInheritanceAnnotation;
    private final ConstructorMetadata constructor;

    DefaultEntityMetadata(String name, List<String> fieldsName, Class<?> type, List<FieldMetadata> fields, Map<String, NativeMapping> javaFieldGroupedByColumn, Map<String, FieldMetadata> fieldsGroupedByName, InstanceSupplier instanceSupplier, InheritanceMetadata inheritance, ConstructorMetadata constructor, boolean hasInheritanceAnnotation) {
        this.name = name;
        this.simpleName = type.getSimpleName();
        this.className = type.getName();
        this.fieldsName = fieldsName;
        this.type = type;
        this.fields = fields;
        this.fieldsGroupedByName = fieldsGroupedByName;
        this.javaFieldGroupedByColumn = javaFieldGroupedByColumn;
        this.instanceSupplier = instanceSupplier;
        this.id = fields.stream().filter(FieldMetadata::isId).findFirst().orElse(null);
        this.inheritance = inheritance;
        this.constructor = constructor;
        this.hasInheritanceAnnotation = hasInheritanceAnnotation;
    }

    public String name() {
        return this.name;
    }

    public String simpleName() {
        return this.simpleName;
    }

    public String className() {
        return this.className;
    }

    public List<String> fieldsName() {
        return this.fieldsName;
    }

    public Class<?> type() {
        return this.type;
    }

    public Optional<InheritanceMetadata> inheritance() {
        return Optional.ofNullable(this.inheritance);
    }

    public boolean hasEntityName() {
        return Objects.isNull(this.inheritance) || this.hasInheritanceAnnotation;
    }

    public boolean isInheritance() {
        return this.hasInheritanceAnnotation;
    }

    public List<FieldMetadata> fields() {
        return this.fields;
    }

    public <T> T newInstance() {
        return this.instanceSupplier.get();
    }

    public ConstructorMetadata constructor() {
        return this.constructor;
    }

    public String columnField(String javaField) {
        Objects.requireNonNull(javaField, "javaField is required");
        return Optional.ofNullable(this.javaFieldGroupedByColumn.get(javaField)).map(NativeMapping::nativeField).orElse(javaField);
    }

    public Optional<FieldMetadata> fieldMapping(String javaField) {
        Objects.requireNonNull(javaField, "javaField is required");
        return Optional.ofNullable(this.javaFieldGroupedByColumn.get(javaField)).map(NativeMapping::fieldMetadata);
    }

    public Map<String, FieldMetadata> fieldsGroupByName() {
        return this.fieldsGroupedByName;
    }

    public Optional<FieldMetadata> id() {
        return Optional.ofNullable(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultEntityMetadata)) {
            return false;
        }
        DefaultEntityMetadata that = (DefaultEntityMetadata)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }

    public String toString() {
        return "DefaultEntityMetadata{name='" + this.name + "', fieldsName=" + this.fieldsName + ", classInstance=" + this.type + ", fields=" + this.fields + ", instanceSupplier=" + this.instanceSupplier + ", javaFieldGroupedByColumn=" + this.javaFieldGroupedByColumn + ", fieldsGroupedByName=" + this.fieldsGroupedByName + ", id=" + this.id + ", inheritance=" + this.inheritance + ", hasInheritanceAnnotation=" + this.hasInheritanceAnnotation + "}";
    }

    static EntityMetadataBuilder builder() {
        return new EntityMetadataBuilder();
    }
}

