/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.mapping.keyvalue.AbstractKeyValueTemplate;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueEntityConverter;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueEventPersistManager;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplate;

@ApplicationScoped
public class KeyValueTemplateProducer
implements Function<BucketManager, KeyValueTemplate> {
    @Inject
    private KeyValueEntityConverter converter;
    @Inject
    private KeyValueEventPersistManager eventManager;

    @Override
    public KeyValueTemplate apply(BucketManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerKeyValueTemplate(this.converter, manager, this.eventManager);
    }

    @Vetoed
    static class ProducerKeyValueTemplate
    extends AbstractKeyValueTemplate {
        private KeyValueEntityConverter converter;
        private BucketManager manager;
        private KeyValueEventPersistManager eventManager;

        ProducerKeyValueTemplate(KeyValueEntityConverter converter, BucketManager manager, KeyValueEventPersistManager eventManager) {
            this.converter = converter;
            this.manager = manager;
            this.eventManager = eventManager;
        }

        ProducerKeyValueTemplate() {
        }

        @Override
        protected KeyValueEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected BucketManager getManager() {
            return this.manager;
        }

        @Override
        protected KeyValueEventPersistManager getEventManager() {
            return this.eventManager;
        }
    }
}

