/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.AttributeConverter;
import java.util.Objects;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.keyvalue.KeyValueEntity;
import org.eclipse.jnosql.mapping.IdNotFoundException;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;

public abstract class KeyValueEntityConverter {
    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    public KeyValueEntity toKeyValue(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        Class<?> type = entity.getClass();
        FieldMetadata key = this.getId(type);
        Object value = key.read(entity);
        Objects.requireNonNull(value, String.format("The key field %s is required", key.name()));
        return KeyValueEntity.of((Object)this.getKey(value, type, false), (Object)entity);
    }

    public <T> T toEntity(Class<T> type, KeyValueEntity entity) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(entity, "entity is required");
        Object bean = entity.value(type);
        if (Objects.isNull(bean)) {
            return null;
        }
        Object key = this.getKey(entity.key(), type, true);
        FieldMetadata id = this.getId(type);
        id.write(bean, key);
        return (T)bean;
    }

    private <T> Object getKey(Object key, Class<T> type, boolean toEntity) {
        FieldMetadata id = this.getId(type);
        if (id.converter().isPresent()) {
            AttributeConverter attributeConverter = this.getConverters().get((FieldParameterMetadata)id);
            if (toEntity) {
                return attributeConverter.convertToEntityAttribute(key);
            }
            return attributeConverter.convertToDatabaseColumn(key);
        }
        return Value.of((Object)key).get(id.type());
    }

    private FieldMetadata getId(Class<?> type) {
        EntityMetadata mapping = this.getEntities().get(type);
        return (FieldMetadata)mapping.id().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
    }
}

