/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.spi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.keyvalue.query.RepositoryKeyValueBean;
import org.eclipse.jnosql.mapping.keyvalue.spi.TemplateBean;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;

public class KeyValueExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(KeyValueExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();

    <T, X extends BucketManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.KEY_VALUE, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ClassScanner scanner = ClassScanner.load();
        Set crudTypes = scanner.repositoriesStandard();
        LOGGER.info(String.format("Processing Key-Value extension: %d databases crud %d found", this.databases.size(), crudTypes.size()));
        LOGGER.info("Processing repositories as a Key-Value implementation: " + crudTypes);
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_KEY_VALUE)) {
                afterBeanDiscovery.addBean(new RepositoryKeyValueBean((Class)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean(new RepositoryKeyValueBean((Class)type, database.getProvider())));
        });
    }
}

