/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.query;

import jakarta.data.repository.BasicRepository;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplate;
import org.eclipse.jnosql.mapping.keyvalue.KeyValueTemplateProducer;
import org.eclipse.jnosql.mapping.keyvalue.query.KeyValueRepositoryProxy;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;

@ApplicationScoped
public class KeyValueRepositoryProducer {
    @Inject
    private KeyValueTemplateProducer producer;
    @Inject
    private EntitiesMetadata entities;

    public <T, K, R extends BasicRepository<T, K>> R get(Class<R> repositoryClass, BucketManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        KeyValueTemplate template = this.producer.apply(manager);
        return this.get(repositoryClass, template);
    }

    public <T, K, R extends BasicRepository<T, K>> R get(Class<R> repositoryClass, KeyValueTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        KeyValueRepositoryProxy handler = new KeyValueRepositoryProxy(repositoryClass, this.entities, template);
        return (R)((BasicRepository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

