/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.configuration;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.keyvalue.BucketManager;
import org.eclipse.jnosql.communication.keyvalue.BucketManagerFactory;
import org.eclipse.jnosql.communication.keyvalue.KeyValueConfiguration;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class BucketManagerSupplier
implements Supplier<BucketManager> {
    private static final Logger LOGGER = Logger.getLogger(BucketManagerSupplier.class.getName());

    BucketManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public BucketManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        KeyValueConfiguration configuration = settings.get((Supplier)MappingConfigurations.KEY_VALUE_PROVIDER, Class.class).filter(KeyValueConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (KeyValueConfiguration)Reflections.newInstance((Class)c);
        }).orElseGet(KeyValueConfiguration::getConfiguration);
        BucketManagerFactory managerFactory = (BucketManagerFactory)configuration.apply((Object)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.KEY_VALUE_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.KEY_VALUE_DATABASE.get()));
        BucketManager manager = (BucketManager)managerFactory.apply((Object)db);
        LOGGER.log(Level.FINEST, "Starting  a BucketManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes BucketManager manager) {
        LOGGER.log(Level.FINEST, "Closing BucketManager resource, database name: " + manager.name());
        manager.close();
    }
}

