/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.spi;

import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplateProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.spi.AbstractBean;

class TemplateBean
extends AbstractBean<KeyValueTemplate> {
    private final Set<Type> types = Collections.singleton(KeyValueTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofKeyValue((String)provider));
    }

    public Class<?> getBeanClass() {
        return KeyValueTemplate.class;
    }

    public KeyValueTemplate create(CreationalContext<KeyValueTemplate> context) {
        KeyValueTemplateProducer producer = (KeyValueTemplateProducer)this.getInstance(KeyValueTemplateProducer.class);
        BucketManager manager = this.getManager();
        return producer.get(manager);
    }

    private BucketManager getManager() {
        return (BucketManager)this.getInstance(BucketManager.class, (Annotation)DatabaseQualifier.ofKeyValue((String)this.provider));
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return KeyValueTemplate.class.getName() + DatabaseType.KEY_VALUE + "-" + this.provider;
    }
}

