/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.query;

import jakarta.nosql.mapping.DynamicQueryException;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.jnosql.mapping.query.RepositoryType;
import org.eclipse.jnosql.mapping.repository.DynamicQueryMethodReturn;

public abstract class AbstractKeyValueRepositoryProxy<T>
implements InvocationHandler {
    protected abstract Repository getRepository();

    protected abstract KeyValueTemplate getTemplate();

    protected abstract Class<T> getType();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                Class<T> typeClass = this.getType();
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare(q, typeClass)).withQueryConverter(q -> this.getTemplate().query(q, typeClass)).build();
                return methodReturn.execute();
            }
        }
        throw new DynamicQueryException("Key Value repository does not support query method");
    }
}

