/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue.configuration;

import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.keyvalue.BucketManagerFactory;
import jakarta.nosql.keyvalue.KeyValueConfiguration;
import jakarta.nosql.mapping.MappingException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class BucketManagerSupplier
implements Supplier<BucketManager> {
    private static final Logger LOGGER = Logger.getLogger(BucketManagerSupplier.class.getName());

    BucketManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public BucketManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        KeyValueConfiguration configuration = settings.get((Supplier)MappingConfigurations.KEY_VALUE_PROVIDER, Class.class).filter(KeyValueConfiguration.class::isAssignableFrom).map(c -> {
            Reflections reflections = (Reflections)CDI.current().select(Reflections.class, new Annotation[0]).get();
            return (KeyValueConfiguration)reflections.newInstance(c);
        }).orElseGet(KeyValueConfiguration::getConfiguration);
        BucketManagerFactory managerFactory = (BucketManagerFactory)configuration.apply((Object)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.KEY_VALUE_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.KEY_VALUE_DATABASE));
        BucketManager manager = (BucketManager)managerFactory.apply((Object)db);
        LOGGER.log(Level.FINEST, "Starting  a BucketManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes BucketManager manager) {
        LOGGER.log(Level.FINEST, "Closing BucketManager resource, database name: " + manager.getName());
        manager.close();
    }
}

