/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.keyvalue;

import jakarta.nosql.keyvalue.BucketManager;
import jakarta.nosql.mapping.keyvalue.KeyValueEntityConverter;
import jakarta.nosql.mapping.keyvalue.KeyValueEventPersistManager;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplate;
import jakarta.nosql.mapping.keyvalue.KeyValueTemplateProducer;
import jakarta.nosql.mapping.keyvalue.KeyValueWorkflow;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.eclipse.jnosql.mapping.keyvalue.AbstractKeyValueTemplate;

@ApplicationScoped
class DefaultKeyValueTemplateProducer
implements KeyValueTemplateProducer {
    @Inject
    private KeyValueEntityConverter converter;
    @Inject
    private KeyValueWorkflow flow;
    @Inject
    private KeyValueEventPersistManager eventManager;

    DefaultKeyValueTemplateProducer() {
    }

    public KeyValueTemplate get(BucketManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerKeyValueTemplate(this.converter, this.flow, manager, this.eventManager);
    }

    @Vetoed
    static class ProducerKeyValueTemplate
    extends AbstractKeyValueTemplate {
        private KeyValueEntityConverter converter;
        private KeyValueWorkflow flow;
        private BucketManager manager;
        private KeyValueEventPersistManager eventManager;

        ProducerKeyValueTemplate(KeyValueEntityConverter converter, KeyValueWorkflow flow, BucketManager manager, KeyValueEventPersistManager eventManager) {
            this.converter = converter;
            this.flow = flow;
            this.manager = manager;
            this.eventManager = eventManager;
        }

        ProducerKeyValueTemplate() {
        }

        @Override
        protected KeyValueEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected BucketManager getManager() {
            return this.manager;
        }

        @Override
        protected KeyValueWorkflow getFlow() {
            return this.flow;
        }

        @Override
        protected KeyValueEventPersistManager getEventManager() {
            return this.eventManager;
        }
    }
}

