/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.spi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.nosql.Template;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.communication.graph.GraphDatabaseManager;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTemplateProducer;

class TemplateBean
extends AbstractBean<GraphTemplate> {
    private static final Set<Type> TYPES = Set.of(GraphTemplate.class, Template.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofGraph((String)provider));
    }

    public Class<?> getBeanClass() {
        return GraphTemplate.class;
    }

    public GraphTemplate create(CreationalContext<GraphTemplate> context) {
        GraphTemplateProducer producer = (GraphTemplateProducer)this.getInstance(GraphTemplateProducer.class);
        GraphDatabaseManager manager = this.getManager();
        return producer.apply(manager);
    }

    private GraphDatabaseManager getManager() {
        return (GraphDatabaseManager)this.getInstance(GraphDatabaseManager.class, (Annotation)DatabaseQualifier.ofGraph((String)this.provider));
    }

    public Set<Type> getTypes() {
        return TYPES;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return GraphTemplate.class.getName() + DatabaseType.GRAPH + "-" + this.provider;
    }
}

