/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.spi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.graph.query.CustomRepositoryGraphBean;
import org.eclipse.jnosql.mapping.graph.query.RepositoryGraphBean;
import org.eclipse.jnosql.mapping.graph.spi.TemplateBean;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;

public class GraphExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(GraphExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();

    <T, X extends DatabaseManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.GRAPH, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ClassScanner scanner = ClassScanner.load();
        Set crudTypes = scanner.repositoriesStandard();
        Set customRepositories = scanner.customRepositories();
        LOGGER.info(String.format("Processing Graph extension: %d databases crud %d found, custom repositories: %d", this.databases.size(), crudTypes.size(), customRepositories.size()));
        LOGGER.info("Processing repositories as a Graph implementation: " + crudTypes);
        this.databases.forEach(type -> {
            if (!type.getProvider().isBlank()) {
                TemplateBean bean = new TemplateBean(type.getProvider());
                afterBeanDiscovery.addBean((Bean)bean);
            }
        });
        crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_GRAPH)) {
                afterBeanDiscovery.addBean(new RepositoryGraphBean((Class<?>)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean(new RepositoryGraphBean((Class<?>)type, database.getProvider())));
        });
        customRepositories.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_GRAPH)) {
                afterBeanDiscovery.addBean(new CustomRepositoryGraphBean((Class<?>)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean(new CustomRepositoryGraphBean((Class<?>)type, database.getProvider())));
        });
    }
}

